/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.Buttons;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.PingKeyProvider;
import de.caff.asteroid.ScoreFixer;
import de.caff.asteroid.analysis.DumpFileChangeListener;
import de.caff.asteroid.analysis.DumpLoadingListener;
import de.caff.asteroid.analysis.FileFormat;
import de.caff.asteroid.analysis.FrameKeyInfo;
import de.caff.util.Tools;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpFile
implements FileFormat,
PingKeyProvider {
    private String filename;
    private List<FrameKeyInfo> infos = new ArrayList<FrameKeyInfo>();
    private List<Mark> marks = new ArrayList<Mark>();
    private IOException finalException;
    private List<DumpFileChangeListener> changeListeners = new LinkedList<DumpFileChangeListener>();
    private FileType fileType;
    private int clientPort;
    private String ipAddress;
    private String playerName;

    private FileType getFileType(BufferedInputStream is) throws IOException {
        String formatName;
        byte[] intro;
        int firstByte = this.readByte(is);
        FileType result = null;
        if (firstByte == DECAFF_INTRO[0]) {
            intro = DECAFF_INTRO;
            result = FileType.DECAFF_DUMPFILE;
            formatName = "de.caff format";
        } else if (firstByte == CT_INTRO_PREFIX[0]) {
            intro = CT_INTRO_PREFIX;
            formatName = "c't format (version 1 or 2)";
        } else {
            throw new IOException(this.filename + ": Unknown file format!");
        }
        for (int b = 1; b < intro.length; ++b) {
            if (this.readByte(is) == intro[b]) continue;
            throw new IOException(this.filename + ": Unknown file format (expected " + formatName + ")!");
        }
        if (result == null) {
            int version = this.readByte(is);
            if (version == CT_INTRO_POSTFIX_1[0]) {
                result = FileType.CT_DUMPFILE_1;
                intro = CT_INTRO_POSTFIX_1;
            } else if (version == CT_INTRO_POSTFIX_2[0]) {
                result = FileType.CT_DUMPFILE_2;
                intro = CT_INTRO_POSTFIX_2;
            } else {
                throw new IOException(this.filename + ": Unsupported version for c't file format: " + (char)version);
            }
            for (int b = 1; b < intro.length; ++b) {
                if (this.readByte(is) == intro[b]) continue;
                throw new IOException(this.filename + ": Unknown file format (expected " + formatName + ")!");
            }
        }
        return result;
    }

    public DumpFile(InputStream is, String filename) throws IOException {
        this(is, filename, null);
    }

    public DumpFile(InputStream is, String filename, DumpLoadingListener listener) throws IOException {
        long filesize = 0L;
        BufferedInputStream bis = new BufferedInputStream(is);
        if (filename.toLowerCase().endsWith(".zip")) {
            bis.mark(256);
            try {
                ZipInputStream zis = new ZipInputStream(bis);
                ZipEntry entry = zis.getNextEntry();
                if (entry == null) {
                    throw new ZipException();
                }
                bis = new BufferedInputStream(zis);
                filesize = entry.getSize();
            }
            catch (IOException e) {
                bis.reset();
            }
        }
        this.init(bis, filename, filesize, listener);
    }

    public DumpFile(String filename) throws IOException {
        this(filename, null);
    }

    public DumpFile(String filename, DumpLoadingListener listener) throws IOException {
        long fileSize = 0L;
        BufferedInputStream is = null;
        if (filename.toLowerCase().endsWith(".zip")) {
            try {
                ZipFile zip = new ZipFile(filename);
                Enumeration<? extends ZipEntry> it = zip.entries();
                if (it.hasMoreElements()) {
                    ZipEntry entry = it.nextElement();
                    is = new BufferedInputStream(zip.getInputStream(entry));
                    fileSize = entry.getSize();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (is == null) {
            FileInputStream fis = new FileInputStream(filename);
            is = new BufferedInputStream(fis);
            fileSize = new File(filename).length();
        }
        this.init(is, filename, fileSize, listener);
    }

    private void init(BufferedInputStream is, String filename, long filesize, DumpLoadingListener listener) throws IOException {
        this.filename = filename;
        is.mark(256);
        try {
            GZIPInputStream gis = new GZIPInputStream(is);
            is = new BufferedInputStream(gis);
            filesize = 0L;
        }
        catch (IOException x) {
            is.reset();
        }
        this.fileType = this.getFileType(is);
        switch (this.fileType) {
            case CT_DUMPFILE_1: 
            case CT_DUMPFILE_2: {
                if (listener != null) {
                    if (filesize > 0L) {
                        switch (this.fileType) {
                            case CT_DUMPFILE_1: {
                                listener.setExpectedFrames((int)((filesize - 25L) / 1025L));
                                break;
                            }
                            case CT_DUMPFILE_2: {
                                listener.setExpectedFrames((int)((filesize - 57L) / 1025L));
                            }
                        }
                    } else {
                        listener.setExpectedFrames(0);
                    }
                }
                this.readCtFile(is, listener);
                break;
            }
            case DECAFF_DUMPFILE: {
                if (listener != null) {
                    if (filesize > 0L) {
                        listener.setExpectedFrames((int)((filesize - (long)DECAFF_INTRO.length) / 1046L));
                    } else {
                        listener.setExpectedFrames(0);
                    }
                }
                this.readDecaffFile(is, listener);
            }
        }
        if (!this.infos.isEmpty()) {
            this.marks.add(new Mark(this.infos.size(), MarkType.DUMP_END));
        }
        this.runPreparer(new ScoreFixer());
    }

    private void readCtFile(BufferedInputStream is, DumpLoadingListener listener) throws IOException {
        this.clientPort = this.readByte(is) | this.readByte(is) << 8;
        this.ipAddress = String.format("%d.%d.%d.%d", this.readByte(is), this.readByte(is), this.readByte(is), this.readByte(is));
        for (int i = 0; i < 8; ++i) {
            this.readByte(is);
        }
        if (this.fileType == FileType.CT_DUMPFILE_2) {
            int len;
            byte[] nameBytes = new byte[32];
            if (is.read(nameBytes) < 32) {
                throw new IOException(this.filename + ": Premature EOF!");
            }
            for (len = nameBytes.length; len > 0 && nameBytes[len - 1] == 0; --len) {
            }
            if (len > 0) {
                this.playerName = new String(nameBytes, 0, len, "utf-8");
            }
        }
        if (listener != null) {
            listener.setExpectedFrames(18000);
        }
        try {
            int len;
            byte[] frame = new byte[1026];
            MarkType markType = null;
            while ((len = is.read(frame, 0, 1024)) > 0) {
                if (len < 1024) {
                    throw new IOException(this.filename + ": Premature EOF!");
                }
                int count = this.infos.size();
                FrameKeyInfo info = new FrameKeyInfo(count, (long)count * 1000L / 60L, frame);
                info.addButtons((byte)this.readByte(is));
                this.infos.add(info);
                markType = this.checkForMark(markType, info, listener);
            }
        }
        catch (IOException e) {
            this.finalException = e;
            e.printStackTrace();
        }
    }

    private int readByte(BufferedInputStream is) throws IOException {
        int nextByte = is.read();
        if (nextByte < 0) {
            throw new IOException(this.filename + ": Premature EOF!");
        }
        return nextByte;
    }

    private void readDecaffFile(BufferedInputStream is, DumpLoadingListener listener) {
        byte[] frame = new byte[1026];
        MarkType markType = null;
        try {
            int nextByte;
            FrameKeyInfo info = null;
            while ((nextByte = is.read()) >= 0) {
                switch (nextByte) {
                    case 79: {
                        long timestamp = DumpFile.readTimestamp(is);
                        int bytesRead = is.read(frame, 0, 8);
                        if (bytesRead < 8) {
                            throw new IOException(String.format("%s: premature EOF!", this.filename));
                        }
                        DumpFile.checkKeyPacket(frame);
                        if (info != null) {
                            info.addButtons(timestamp, frame[KEY_MASK_INDEX], frame[KEY_PING_INDEX]);
                            break;
                        }
                        System.out.println(String.format("%s: keys before first frame: %s!", this.filename, new Buttons(frame[KEY_MASK_INDEX])));
                        break;
                    }
                    case 73: {
                        long timestamp = DumpFile.readTimestamp(is);
                        int bytesRead = is.read(frame);
                        if (bytesRead < 1026) {
                            throw new IOException(String.format("%s: premature EOF!", this.filename));
                        }
                        info = new FrameKeyInfo(this.infos.size(), timestamp, frame, this);
                        markType = this.checkForMark(markType, info, listener);
                        this.infos.add(info);
                    }
                }
            }
        }
        catch (IOException e) {
            this.finalException = e;
            e.printStackTrace();
        }
    }

    private MarkType checkForMark(MarkType prevMarkType, FrameKeyInfo info, DumpLoadingListener listener) {
        MarkType newMarkType = DumpFile.getFrameType(info);
        if (newMarkType != prevMarkType && (newMarkType != MarkType.SHIP_VANISHES || prevMarkType != MarkType.GAME_START)) {
            if (prevMarkType == MarkType.GAME_END && newMarkType == MarkType.SHIP_VANISHES) {
                newMarkType = MarkType.GAME_START;
            }
            this.marks.add(new Mark(info.getFrameInfo().getIndex(), newMarkType));
            if (listener != null) {
                listener.marksChanged(this.marks);
            }
            prevMarkType = newMarkType;
        } else if (listener != null) {
            listener.frameCountChanged(info.getFrameInfo().getIndex() + 1);
        }
        return prevMarkType;
    }

    public String getFilename() {
        return this.filename;
    }

    private static long readTimestamp(InputStream is) throws IOException {
        long result = 0L;
        for (int b = 0; b < 8; ++b) {
            int bb = is.read();
            if (bb < 0) {
                throw new IOException("Premature EOF!");
            }
            result |= (long)(bb & 0xFF) << 8 * b;
        }
        return result;
    }

    private static void checkKeyPacket(byte[] keyPacket) throws IOException {
        for (int i = KEY_PACKET_INTRO.length - 1; i >= 0; --i) {
            if (keyPacket[i] == KEY_PACKET_INTRO[i]) continue;
            throw new IOException("Invalid key packet!");
        }
    }

    private static MarkType getFrameType(FrameKeyInfo info) {
        return info.getFrameInfo().isGameRunning() ? (info.getFrameInfo().getSpaceShip() != null ? MarkType.SHIP_APPEARS : MarkType.SHIP_VANISHES) : MarkType.GAME_END;
    }

    public List<FrameKeyInfo> getInfos() {
        return this.infos;
    }

    public FrameKeyInfo getLastInfo() {
        return this.infos.isEmpty() ? null : this.infos.get(this.infos.size() - 1);
    }

    public List<Mark> getMarks() {
        return this.marks;
    }

    public IOException getFinalException() {
        return this.finalException;
    }

    public void runPreparer(final FramePreparer preparer) {
        new Thread(new Runnable(){

            public void run() {
                DumpFile.this.runPrep(preparer);
            }
        }).start();
    }

    public void runPreparerDirectly(FramePreparer preparer) {
        this.runPrep(preparer);
    }

    private synchronized void runPrep(FramePreparer preparer) {
        LinkedList<FrameInfo> pending = new LinkedList<FrameInfo>();
        for (FrameKeyInfo info : this.infos) {
            pending.add(info.getFrameInfo());
            if (pending.size() > 256) {
                pending.remove(0);
            }
            preparer.prepareFrames(pending);
        }
        this.informDumpFileChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDumpFileChangeListener(DumpFileChangeListener listener) {
        List<DumpFileChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDumpFileChangeListener(DumpFileChangeListener listener) {
        List<DumpFileChangeListener> list = this.changeListeners;
        synchronized (list) {
            return this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informDumpFileChangeListeners() {
        ArrayList<DumpFileChangeListener> tmp;
        List<DumpFileChangeListener> list = this.changeListeners;
        synchronized (list) {
            if (this.changeListeners.isEmpty()) {
                return;
            }
            tmp = new ArrayList<DumpFileChangeListener>(this.changeListeners);
        }
        for (DumpFileChangeListener listener : tmp) {
            listener.dumpFileChange();
        }
    }

    @Override
    public int getKeysForPing(int frameNr, int ping) {
        if (ping != 0) {
            int minFrame = Math.max(frameNr - 255, 0);
            if (frameNr >= this.infos.size()) {
                frameNr = this.infos.size() - 1;
            }
            while (frameNr >= minFrame) {
                if (Tools.byteToUnsigned(this.infos.get(frameNr).getButtons().get(0).getPingID()) == ping) {
                    return this.infos.get(frameNr).getButtons().get(0).getButtons().getKeys();
                }
                --frameNr;
            }
        }
        return 0;
    }

    @Override
    public long getTimestampForPing(int frameNr, int ping) {
        if (ping != 0) {
            int minFrame = Math.max(frameNr - 255, 0);
            if (frameNr >= this.infos.size()) {
                frameNr = this.infos.size() - 1;
            }
            while (frameNr >= minFrame) {
                if (Tools.byteToUnsigned(this.infos.get(frameNr).getButtons().get(0).getPingID()) == ping) {
                    return this.infos.get(frameNr).getButtons().get(0).getTimestamp();
                }
                --frameNr;
            }
        }
        return 0L;
    }

    @Override
    public boolean isStillKnown(int frameNr, int ping) {
        return frameNr >= 0 && frameNr < this.infos.size() && ping != 0;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public static void main(String[] args) throws IOException {
        for (String arg : args) {
            DumpFile file = new DumpFile(arg);
            System.out.println(String.format("%s: %d frames and %d marks.", arg, file.getInfos().size(), file.getMarks().size()));
            file.runPrep(new ScoreFixer());
            if (file.getInfos().isEmpty()) continue;
            System.out.println("Score at end: " + file.getLastInfo().getFrameInfo().getScore());
        }
    }

    public static class Mark {
        private int frameIndex;
        private MarkType markType;

        public Mark(int frameIndex, MarkType markType) {
            this.frameIndex = frameIndex;
            this.markType = markType;
        }

        public int getFrameIndex() {
            return this.frameIndex;
        }

        public MarkType getMarkType() {
            return this.markType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        DECAFF_DUMPFILE,
        CT_DUMPFILE_1,
        CT_DUMPFILE_2;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MarkType {
        GAME_START,
        GAME_END,
        SHIP_APPEARS,
        SHIP_VANISHES,
        DUMP_END;

    }
}

