/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.GameData;
import de.caff.asteroid.analysis.AbstractBasicTimeLine;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.DumpFileChangeListener;
import de.caff.asteroid.analysis.FrameKeyInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLine
extends AbstractBasicTimeLine
implements GameData {
    private static final Color MARKER_COLOR = Color.black;
    private DumpFile dumpFile;
    private int currentIndex = 0;
    private List<FrameListener> frameListeners = new LinkedList<FrameListener>();
    private List<DumpFileChangeListener> changeListeners = new LinkedList<DumpFileChangeListener>();
    private MouseWheelListener mouseWheelListener = new MouseWheelListener(){

        public void mouseWheelMoved(MouseWheelEvent e) {
            if ((e.getModifiersEx() & 0x40) != 0) {
                int n = e.getWheelRotation();
                if (n > 0) {
                    while (n-- > 0) {
                        DumpFile.Mark mark = TimeLine.this.getPreviousMarker(TimeLine.this.getCurrentIndex());
                        if (mark == null) continue;
                        TimeLine.this.setCurrentIndex(mark.getFrameIndex());
                    }
                } else {
                    while (n++ < 0) {
                        DumpFile.Mark mark = TimeLine.this.getNextMarker(TimeLine.this.getCurrentIndex());
                        if (mark == null) continue;
                        TimeLine.this.setCurrentIndex(mark.getFrameIndex());
                    }
                }
            } else {
                TimeLine.this.setCurrentIndex(TimeLine.this.getCurrentIndex() - e.getWheelRotation());
            }
        }
    };

    public TimeLine(DumpFile dumpFile) {
        this.setMinimumSize(new Dimension(100, 32));
        this.setPreferredSize(this.getMinimumSize());
        this.setOpaque(true);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    TimeLine.this.setCurrentFrom(e);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if ((e.getModifiersEx() & 0x400) != 0) {
                    TimeLine.this.setCurrentFrom(e);
                }
            }
        });
        this.addMouseWheelListener(this.mouseWheelListener);
        this.setDumpFile(dumpFile);
    }

    public void setDumpFile(DumpFile dumpFile) {
        if (this.dumpFile != null) {
            for (DumpFileChangeListener l : this.changeListeners) {
                this.dumpFile.removeDumpFileChangeListener(l);
            }
        }
        this.dumpFile = dumpFile;
        if (dumpFile != null) {
            for (DumpFileChangeListener l : this.changeListeners) {
                dumpFile.addDumpFileChangeListener(l);
            }
        }
        this.currentIndex = -1;
        this.setCurrentIndex(0);
    }

    private void setCurrentFrom(MouseEvent e) {
        int index = this.getIndexAt(e.getPoint());
        if (index >= 0) {
            DumpFile.Mark mark = this.getNearestMarker(index);
            int screenX = this.indexToScreen(mark.getFrameIndex());
            if (Math.abs(screenX - e.getX()) < 2) {
                index = mark.getFrameIndex();
            }
            this.setCurrentIndex(index);
        }
    }

    public void setCurrentIndex(int frameIndex) {
        if (this.hasFrames()) {
            if (frameIndex < 0) {
                frameIndex = 0;
            } else if (frameIndex >= this.dumpFile.getInfos().size()) {
                frameIndex = this.dumpFile.getInfos().size() - 1;
            }
            if (frameIndex != this.currentIndex) {
                this.currentIndex = frameIndex;
                this.informFrameListeners(this.dumpFile.getInfos().get(frameIndex).getFrameInfo());
                this.repaint();
            }
        }
    }

    public boolean hasFrames() {
        return this.dumpFile != null && !this.dumpFile.getInfos().isEmpty();
    }

    public int getIndexAt(Point p) {
        return this.isValid() ? this.screenToIndex(p.x) : -1;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public FrameKeyInfo getCurrentInfo() {
        return this.hasFrames() ? this.dumpFile.getInfos().get(this.getCurrentIndex()) : null;
    }

    public DumpFile.Mark getNearestMarker(int index) {
        DumpFile.Mark nearest = null;
        if (this.hasFrames()) {
            int minDistance = Integer.MAX_VALUE;
            for (DumpFile.Mark mark : this.getMarks()) {
                int dist = Math.abs(mark.getFrameIndex() - index);
                if (dist < minDistance) {
                    minDistance = dist;
                    nearest = mark;
                    continue;
                }
                if (dist <= minDistance) continue;
                break;
            }
        }
        return nearest;
    }

    public DumpFile.Mark getNextMarker(int index) {
        DumpFile.Mark next = null;
        if (this.hasFrames()) {
            for (DumpFile.Mark mark : this.getMarks()) {
                if (mark.getFrameIndex() <= index) continue;
                next = mark;
                break;
            }
        }
        return next;
    }

    public DumpFile.Mark getPreviousMarker(int index) {
        DumpFile.Mark prev = null;
        if (this.hasFrames()) {
            DumpFile.Mark last = null;
            for (DumpFile.Mark mark : this.getMarks()) {
                if (mark.getFrameIndex() >= index) {
                    prev = last;
                    break;
                }
                last = mark;
            }
        }
        return prev;
    }

    public DumpFile getDumpFile() {
        return this.dumpFile;
    }

    private int screenToIndex(int screenX) {
        return this.isValid() ? (int)((double)(screenX - 6) / this.getScale()) : -1;
    }

    public void addFrameListener(FrameListener listener) {
        this.frameListeners.add(listener);
    }

    public boolean removeFrameListener(FrameListener listener) {
        return this.frameListeners.remove(listener);
    }

    private void informFrameListeners(FrameInfo frameInfo) {
        for (FrameListener listener : this.frameListeners) {
            listener.frameReceived(frameInfo);
        }
    }

    @Override
    public int getFrameCount() {
        return this.dumpFile.getInfos().size();
    }

    public int getSessionTime(int frameIndex) {
        if (this.hasFrames()) {
            if (frameIndex < 0) {
                frameIndex = 0;
            } else if (frameIndex >= this.getFrameCount()) {
                frameIndex = this.getFrameCount() - 1;
            }
            DumpFile.Mark prevMarker = this.getPreviousMarker(frameIndex);
            while (prevMarker != null) {
                if (prevMarker.getMarkType() == DumpFile.MarkType.GAME_START) {
                    return (frameIndex - prevMarker.getFrameIndex()) / 60;
                }
                prevMarker = this.getPreviousMarker(prevMarker.getFrameIndex());
            }
            return frameIndex / 60;
        }
        return 0;
    }

    public int getCurrentSessionTime() {
        return this.getSessionTime(this.getCurrentIndex());
    }

    public void addDumpFileChangeListener(DumpFileChangeListener listener) {
        this.changeListeners.add(listener);
        if (this.dumpFile != null) {
            this.dumpFile.addDumpFileChangeListener(listener);
        }
    }

    public boolean removeDumpFileChangeListener(DumpFileChangeListener listener) {
        boolean result = this.changeListeners.remove(listener);
        if (result && this.dumpFile != null) {
            this.dumpFile.removeDumpFileChangeListener(listener);
        }
        return result;
    }

    public MouseWheelListener getMouseWheelListener() {
        return this.mouseWheelListener;
    }

    @Override
    protected Collection<DumpFile.Mark> getMarks() {
        return this.dumpFile.getMarks();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getFrameCount() > 0) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(MARKER_COLOR);
            int markerPos = this.indexToScreen(this.currentIndex);
            g2.drawLine(markerPos, 0, markerPos, this.getHeight());
            GeneralPath triangles = new GeneralPath();
            triangles.moveTo(markerPos, 8.0f);
            triangles.lineTo(markerPos + 4, 1.0f);
            triangles.lineTo(markerPos - 4, 1.0f);
            triangles.closePath();
            int y = this.getHeight() - 1;
            triangles.moveTo(markerPos, y - 8);
            triangles.lineTo(markerPos + 4, y);
            triangles.lineTo(markerPos - 4, y);
            triangles.closePath();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.fill(triangles);
        }
    }
}

