/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bullet
extends MovingGameObject {
    private static final Color[] HALO_COLORS = new Color[]{Color.white, Color.white, new Color(240, 240, 240), new Color(192, 192, 192), new Color(128, 128, 128), new Color(64, 64, 64)};
    private final int index;

    public Bullet(int index, int x, int y) {
        super(x, y);
        this.index = index;
    }

    @Override
    public int getSize() {
        return 0;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawVelocityVector(g, Color.blue);
        Color lastColor = null;
        for (int i = HALO_COLORS.length - 1; i >= 0; --i) {
            Color color = HALO_COLORS[i];
            if (color.equals(lastColor)) continue;
            g.setColor(color);
            g.fillOval(this.x - i, this.y - i, 2 * i + 1, 2 * i + 1);
            lastColor = color;
        }
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Integer>("Lifetime", this.getLifetime()));
        return props;
    }

    @Override
    public String getObjectType() {
        return "Bullet";
    }

    public String toString() {
        return String.format("Bullet@(%d,%d)", this.getX(), this.getY());
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.getX() - 1, this.getY() - 1, 2, 2);
    }
}

