/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FramePreparer;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoreFixer
implements FramePreparer {
    private static final int GAME_SCORE_WRAP = 100000;

    @Override
    public void prepareFrames(LinkedList<FrameInfo> frameInfos) {
        if (frameInfos.size() >= 2) {
            FrameInfo lastFrame = frameInfos.getLast();
            int lastScore = lastFrame.getScore();
            FrameInfo prevFrame = frameInfos.get(frameInfos.size() - 2);
            int prevScore = prevFrame.getScore();
            if (prevFrame.isGameRunning() && prevScore > lastScore) {
                if (lastScore == -1) {
                    lastFrame.setScore(prevScore);
                } else {
                    int fixScore = lastScore + prevScore / 100000 * 100000;
                    if (fixScore < prevScore) {
                        fixScore += 100000;
                    }
                    lastFrame.setScore(fixScore);
                }
            }
        }
    }
}

