/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.util.Utility;
import de.caff.util.debug.AnyMessageDebugListener;
import de.caff.util.debug.AssertionFailedError;
import de.caff.util.debug.AssertionMessageDebugListener;
import de.caff.util.debug.CookedMessageDebugListener;
import de.caff.util.debug.DebugConstants;
import de.caff.util.debug.DebugMessageCook;
import de.caff.util.debug.DebuggingOutputStream;
import de.caff.util.debug.ErrorMessageDebugListener;
import de.caff.util.debug.FatalMessageDebugListener;
import de.caff.util.debug.FilteringDebugMessageWindow;
import de.caff.util.debug.Format;
import de.caff.util.debug.LogMessageListener;
import de.caff.util.debug.ObjectInspector;
import de.caff.util.debug.SimpleOutputtingDebugListener;
import de.caff.util.debug.StandardMessageDebugListener;
import de.caff.util.debug.TraceMessageDebugListener;
import de.caff.util.debug.WarningMessageDebugListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JFrame;

public class Debug
implements DebugConstants {
    private static long _mask = 0L;
    private static boolean _bufferStreams = false;
    private static DebugMessageCook _cook = new DebugMessageCook();
    private static Collection _traceList = new LinkedList();
    private static Collection _stdList = new LinkedList();
    private static Collection _warnList = new LinkedList();
    private static Collection _errorList = new LinkedList();
    private static Collection _fatalList = new LinkedList();
    private static Collection _assertList = new LinkedList();
    private static Collection _logList = new LinkedList();
    private static Collection _modeList = new LinkedList();
    private static PrintStream _oldStdout = null;
    private static StringBuffer _collectedStdout = null;
    private static PrintStream _oldStderr = null;
    private static StringBuffer _collectedStderr = null;

    public static void addModeChangeListener(ModeChangeListener modeChangeListener) {
        _modeList.add(modeChangeListener);
    }

    public static void removeModeChangeListener(ModeChangeListener modeChangeListener) {
        _modeList.remove(modeChangeListener);
    }

    private static void informModeChangeListeners(int n, boolean bl) {
        Iterator iterator = _modeList.iterator();
        while (iterator.hasNext()) {
            ((ModeChangeListener)iterator.next()).modeChanged(n, bl);
        }
    }

    private static void informStdoutCaptureModeListeners(boolean bl) {
        Iterator iterator = _modeList.iterator();
        while (iterator.hasNext()) {
            ((ModeChangeListener)iterator.next()).stdoutCaptureChanged(bl);
        }
    }

    private static void informStderrCaptureModeListeners(boolean bl) {
        Iterator iterator = _modeList.iterator();
        while (iterator.hasNext()) {
            ((ModeChangeListener)iterator.next()).stderrCaptureChanged(bl);
        }
    }

    public static void addTraceMessageDebugListener(TraceMessageDebugListener traceMessageDebugListener) {
        _traceList.add(traceMessageDebugListener);
    }

    public static void removeTraceMessageDebugListener(TraceMessageDebugListener traceMessageDebugListener) {
        _traceList.remove(traceMessageDebugListener);
    }

    public static void addStandardMessageDebugListener(StandardMessageDebugListener standardMessageDebugListener) {
        _stdList.add(standardMessageDebugListener);
    }

    public static void removeStandardMessageDebugListener(StandardMessageDebugListener standardMessageDebugListener) {
        _stdList.remove(standardMessageDebugListener);
    }

    public static void addWarningMessageDebugListener(WarningMessageDebugListener warningMessageDebugListener) {
        _warnList.add(warningMessageDebugListener);
    }

    public static void removeWarningMessageDebugListener(WarningMessageDebugListener warningMessageDebugListener) {
        _warnList.remove(warningMessageDebugListener);
    }

    public static void addErrorMessageDebugListener(ErrorMessageDebugListener errorMessageDebugListener) {
        _errorList.add(errorMessageDebugListener);
    }

    public static void removeErrorMessageDebugListener(ErrorMessageDebugListener errorMessageDebugListener) {
        _errorList.remove(errorMessageDebugListener);
    }

    public static void addFatalMessageDebugListener(FatalMessageDebugListener fatalMessageDebugListener) {
        _fatalList.add(fatalMessageDebugListener);
    }

    public static void removeFatalMessageDebugListener(FatalMessageDebugListener fatalMessageDebugListener) {
        _fatalList.remove(fatalMessageDebugListener);
    }

    public static void addAssertionMessageDebugListener(AssertionMessageDebugListener assertionMessageDebugListener) {
        _assertList.add(assertionMessageDebugListener);
    }

    public static void removeAssertionMessageDebugListener(AssertionMessageDebugListener assertionMessageDebugListener) {
        _assertList.remove(assertionMessageDebugListener);
    }

    public static void addLogMessageListener(LogMessageListener logMessageListener) {
        _logList.add(logMessageListener);
    }

    public static void removeLogMessageListener(LogMessageListener logMessageListener) {
        _logList.remove(logMessageListener);
    }

    public static void addCookedMessageDebugListener(CookedMessageDebugListener cookedMessageDebugListener) {
        _cook.addListener(cookedMessageDebugListener);
    }

    public static void removeCookedMessageDebugListener(CookedMessageDebugListener cookedMessageDebugListener) {
        _cook.removeListener(cookedMessageDebugListener);
    }

    public static void addAnyMessageDebugListener(AnyMessageDebugListener anyMessageDebugListener) {
        Debug.addTraceMessageDebugListener(anyMessageDebugListener);
        Debug.addStandardMessageDebugListener(anyMessageDebugListener);
        Debug.addWarningMessageDebugListener(anyMessageDebugListener);
        Debug.addErrorMessageDebugListener(anyMessageDebugListener);
        Debug.addFatalMessageDebugListener(anyMessageDebugListener);
        Debug.addAssertionMessageDebugListener(anyMessageDebugListener);
        Debug.addLogMessageListener(anyMessageDebugListener);
    }

    public static void removeAnyMessageDebugListener(AnyMessageDebugListener anyMessageDebugListener) {
        Debug.removeTraceMessageDebugListener(anyMessageDebugListener);
        Debug.removeStandardMessageDebugListener(anyMessageDebugListener);
        Debug.removeWarningMessageDebugListener(anyMessageDebugListener);
        Debug.removeErrorMessageDebugListener(anyMessageDebugListener);
        Debug.removeFatalMessageDebugListener(anyMessageDebugListener);
        Debug.removeAssertionMessageDebugListener(anyMessageDebugListener);
        Debug.removeLogMessageListener(anyMessageDebugListener);
    }

    public static void setMask(long l) {
        if (l != _mask) {
            long l2 = _mask ^ l;
            for (int i = 0; i < 64; ++i) {
                if ((1L << i & l2) == 0L) continue;
                Debug.informModeChangeListeners(i, (l & 1L << i) != 0L);
            }
            _mask = l;
        }
    }

    public static long getMask() {
        return _mask;
    }

    public static void setTraceMode(boolean bl) {
        if (Debug.getTraceMode() != bl) {
            _mask = bl ? (_mask |= 1L) : (_mask &= 0xFFFFFFFFFFFFFFFEL);
            Debug.informModeChangeListeners(0, bl);
        }
    }

    public static boolean getTraceMode() {
        return (_mask & 1L) != 0L;
    }

    public static void setStandardMode(boolean bl) {
        if (Debug.getStandardMode() != bl) {
            _mask = bl ? (_mask |= 2L) : (_mask &= 0xFFFFFFFFFFFFFFFDL);
            Debug.informModeChangeListeners(1, bl);
        }
    }

    public static boolean getStandardMode() {
        return (_mask & 2L) != 0L;
    }

    public static void setWarningMode(boolean bl) {
        if (Debug.getWarningMode() != bl) {
            _mask = bl ? (_mask |= 4L) : (_mask &= 0xFFFFFFFFFFFFFFFBL);
            Debug.informModeChangeListeners(2, bl);
        }
    }

    public static boolean getWarningMode() {
        return (_mask & 4L) != 0L;
    }

    public static void setErrorMode(boolean bl) {
        if (Debug.getErrorMode() != bl) {
            _mask = bl ? (_mask |= 8L) : (_mask &= 0xFFFFFFFFFFFFFFF7L);
            Debug.informModeChangeListeners(3, bl);
        }
    }

    public static boolean getErrorMode() {
        return (_mask & 8L) != 0L;
    }

    public static void setLogMode(boolean bl) {
        if (Debug.getLogMode() != bl) {
            _mask = bl ? (_mask |= 0x20L) : (_mask &= 0xFFFFFFFFFFFFFFDFL);
            Debug.informModeChangeListeners(5, bl);
        }
    }

    public static boolean getLogMode() {
        return (_mask & 0x20L) != 0L;
    }

    public static void setFatalMode(boolean bl) {
        if (Debug.getFatalMode() != bl) {
            _mask = bl ? (_mask |= 0x10L) : (_mask &= 0xFFFFFFFFFFFFFFEFL);
            Debug.informModeChangeListeners(4, bl);
        }
    }

    public static boolean getFatalMode() {
        return (_mask & 0x10L) != 0L;
    }

    public static void setAssertionMode(boolean bl) {
        if (Debug.getAssertionMode() != bl) {
            _mask = bl ? (_mask |= 0x40L) : (_mask &= 0xFFFFFFFFFFFFFFBFL);
            Debug.informModeChangeListeners(6, bl);
        }
    }

    public static boolean getAssertionMode() {
        return (_mask & 0x40L) != 0L;
    }

    private static void distributeTraceMessage(String string) {
        Debug.sendCollectedStreams();
        Iterator iterator = _traceList.iterator();
        while (iterator.hasNext()) {
            ((TraceMessageDebugListener)iterator.next()).receiveTraceMessage(string, Debug.getCallerPosition());
        }
    }

    private static void distributeStandardMessage(String string) {
        Debug.sendCollectedStreams();
        Iterator iterator = _stdList.iterator();
        while (iterator.hasNext()) {
            ((StandardMessageDebugListener)iterator.next()).receiveStandardMessage(string, Debug.getCallerPosition());
        }
    }

    private static void distributeWarningMessage(String string) {
        Debug.sendCollectedStreams();
        Iterator iterator = _warnList.iterator();
        while (iterator.hasNext()) {
            ((WarningMessageDebugListener)iterator.next()).receiveWarningMessage(string, Debug.getCallerPosition());
        }
    }

    private static void distributeErrorMessage(String string) {
        Debug.sendCollectedStreams();
        Iterator iterator = _errorList.iterator();
        while (iterator.hasNext()) {
            ((ErrorMessageDebugListener)iterator.next()).receiveErrorMessage(string, Debug.getCallerPosition());
        }
    }

    private static void distributeLogMessage(String string) {
        Debug.sendCollectedStreams();
        Iterator iterator = _logList.iterator();
        while (iterator.hasNext()) {
            ((LogMessageListener)iterator.next()).receiveLogMessage(string, Debug.getCallerPosition());
        }
    }

    private static void distributeFatalMessage(String string) {
        Debug.sendCollectedStreams();
        int n = 0;
        Iterator iterator = _fatalList.iterator();
        while (iterator.hasNext()) {
            int n2 = ((FatalMessageDebugListener)iterator.next()).receiveFatalMessage(string, Debug.getCallerPosition());
            if (n != 0 || n2 == 0) continue;
            n = n2;
        }
        if (n != 0) {
            System.exit(n);
        }
    }

    private static boolean distributeAssertionMessage(String string) {
        Debug.sendCollectedStreams();
        boolean bl = false;
        Iterator iterator = _assertList.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = ((AssertionMessageDebugListener)iterator.next()).receiveFailedAssertionMessage(string, Debug.getCallerPosition());
            if (bl || !bl2) continue;
            bl = bl2;
        }
        return bl;
    }

    public static void trace(String string) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(string);
        }
    }

    public static void trace(Throwable throwable) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Debug.getStackDump(throwable));
        }
    }

    public static void trace(Object object) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.toString(object));
        }
    }

    public static void trace(String string, Object object) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format((Object)string, object));
        }
    }

    public static void trace(String string, Object object, Object object2) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format(string, object, object2));
        }
    }

    public static void trace(String string, Object object, Object object2, Object object3) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format(string, object, object2, object3));
        }
    }

    public static void trace(String string, Object object, Object object2, Object object3, Object object4) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format(string, object, object2, object3, object4));
        }
    }

    public static void trace(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format(string, object, object2, object3, object4, object5));
        }
    }

    public static void trace(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format(string, object, object2, object3, object4, object5, object6));
        }
    }

    public static void trace(String string, Object[] objectArray) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeTraceMessage(Format.format((Object)string, objectArray));
        }
    }

    public static void message(String string) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(string);
        }
    }

    public static void message(Throwable throwable) {
        if ((_mask & 1L) != 0L) {
            Debug.distributeStandardMessage(Debug.getStackDump(throwable));
        }
    }

    public static void message(Object object) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.toString(object));
        }
    }

    public static void message(String string, Object object) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format((Object)string, object));
        }
    }

    public static void message(String string, Object object, Object object2) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format(string, object, object2));
        }
    }

    public static void message(String string, Object object, Object object2, Object object3) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format(string, object, object2, object3));
        }
    }

    public static void message(String string, Object object, Object object2, Object object3, Object object4) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format(string, object, object2, object3, object4));
        }
    }

    public static void message(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format(string, object, object2, object3, object4, object5));
        }
    }

    public static void message(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format(string, object, object2, object3, object4, object5, object6));
        }
    }

    public static void message(String string, Object[] objectArray) {
        if ((_mask & 2L) != 0L) {
            Debug.distributeStandardMessage(Format.format((Object)string, objectArray));
        }
    }

    public static void warn(String string) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(string);
        }
    }

    public static void warn(Throwable throwable) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Debug.getStackDump(throwable));
        }
    }

    public static void warn(Object object) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.toString(object));
        }
    }

    public static void warn(String string, Object object) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format((Object)string, object));
        }
    }

    public static void warn(String string, Object object, Object object2) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format(string, object, object2));
        }
    }

    public static void warn(String string, Object object, Object object2, Object object3) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format(string, object, object2, object3));
        }
    }

    public static void warn(String string, Object object, Object object2, Object object3, Object object4) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format(string, object, object2, object3, object4));
        }
    }

    public static void warn(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format(string, object, object2, object3, object4, object5));
        }
    }

    public static void warn(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format(string, object, object2, object3, object4, object5, object6));
        }
    }

    public static void warn(String string, Object[] objectArray) {
        if ((_mask & 4L) != 0L) {
            Debug.distributeWarningMessage(Format.format((Object)string, objectArray));
        }
    }

    public static void error(String string) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(string);
        }
    }

    public static void error(Throwable throwable) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Debug.getStackDump(throwable));
        }
    }

    public static void error(Object object) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.toString(object));
        }
    }

    public static void error(String string, Object object) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format((Object)string, object));
        }
    }

    public static void error(String string, Object object, Object object2) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format(string, object, object2));
        }
    }

    public static void error(String string, Object object, Object object2, Object object3) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format(string, object, object2, object3));
        }
    }

    public static void error(String string, Object object, Object object2, Object object3, Object object4) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format(string, object, object2, object3, object4));
        }
    }

    public static void error(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format(string, object, object2, object3, object4, object5));
        }
    }

    public static void error(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format(string, object, object2, object3, object4, object5, object6));
        }
    }

    public static void error(String string, Object[] objectArray) {
        if ((_mask & 8L) != 0L) {
            Debug.distributeErrorMessage(Format.format((Object)string, objectArray));
        }
    }

    public static void fatal(String string) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(string);
        }
    }

    public static void fatal(Throwable throwable) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Debug.getStackDump(throwable));
        }
    }

    public static void fatal(Object object) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.toString(object));
        }
    }

    public static void fatal(String string, Object object) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format((Object)string, object));
        }
    }

    public static void fatal(String string, Object object, Object object2) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format(string, object, object2));
        }
    }

    public static void fatal(String string, Object object, Object object2, Object object3) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format(string, object, object2, object3));
        }
    }

    public static void fatal(String string, Object object, Object object2, Object object3, Object object4) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format(string, object, object2, object3, object4));
        }
    }

    public static void fatal(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format(string, object, object2, object3, object4, object5));
        }
    }

    public static void fatal(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format(string, object, object2, object3, object4, object5, object6));
        }
    }

    public static void fatal(String string, Object[] objectArray) {
        if ((_mask & 0x10L) != 0L) {
            Debug.distributeFatalMessage(Format.format((Object)string, objectArray));
        }
    }

    public static void log(String string) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(string);
        }
    }

    public static void log(Throwable throwable) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Debug.getStackDump(throwable));
        }
    }

    public static void log(Object object) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.toString(object));
        }
    }

    public static void log(String string, Object object) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format((Object)string, object));
        }
    }

    public static void log(String string, Object object, Object object2) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format(string, object, object2));
        }
    }

    public static void log(String string, Object object, Object object2, Object object3) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format(string, object, object2, object3));
        }
    }

    public static void log(String string, Object object, Object object2, Object object3, Object object4) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format(string, object, object2, object3, object4));
        }
    }

    public static void log(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format(string, object, object2, object3, object4, object5));
        }
    }

    public static void log(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format(string, object, object2, object3, object4, object5, object6));
        }
    }

    public static void log(String string, Object[] objectArray) {
        if ((_mask & 0x20L) != 0L) {
            Debug.distributeLogMessage(Format.format((Object)string, objectArray));
        }
    }

    public static void insist(boolean bl) {
        if (!bl && (_mask & 0x40L) != 0L && Debug.distributeAssertionMessage(null)) {
            throw new AssertionFailedError();
        }
    }

    public static void insist(boolean bl, String string) {
        if (!bl && (_mask & 0x40L) != 0L && Debug.distributeAssertionMessage(string)) {
            throw new AssertionFailedError(string);
        }
    }

    public static String getStackDump(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.getBuffer().toString();
    }

    public static String getCallerPosition(int n) {
        n += 2;
        String string = Debug.getStackDump(new Throwable());
        int n2 = 0;
        while (n2 != -1 && n-- > 0) {
            n2 = string.indexOf(10, n2 + 1);
        }
        if (n2 >= 0) {
            int n3;
            String string2;
            if (n2 > 0) {
                ++n2;
            }
            if ((string2 = (n3 = string.indexOf(10, n2)) > -1 ? string.substring(n2, n3).trim() : string.substring(n2).trim()).startsWith("at ")) {
                string2 = string2.substring(3);
            }
            return string2;
        }
        return "???";
    }

    private static String getCallerPosition() {
        String string = Debug.getStackDump(new Throwable());
        String string2 = "at de.caff.util.debug.";
        int n = string.indexOf(10) + 1;
        int n2 = string.indexOf(10, n);
        while (n2 != -1) {
            String string3 = string.substring(n, n2);
            if (string3.indexOf(string2) == -1) {
                String string4 = string3.trim();
                if (string4.startsWith("at ")) {
                    string4 = string4.substring(3);
                }
                return string4;
            }
            n = n2 + 1;
            n2 = string.indexOf(10, n);
        }
        return "???";
    }

    public static JFrame createDebugWindow() {
        return Debug.createDebugWindow(false);
    }

    public static JFrame createDebugWindow(boolean bl) {
        FilteringDebugMessageWindow filteringDebugMessageWindow = new FilteringDebugMessageWindow();
        if (bl) {
            filteringDebugMessageWindow.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
        return filteringDebugMessageWindow;
    }

    static void sendCollectedStdout() {
        if (_collectedStdout != null) {
            String string = _collectedStdout.toString();
            _collectedStdout = null;
            Debug.distributeStandardMessage(string);
        }
    }

    static void sendCollectedStderr() {
        if (_collectedStderr != null) {
            String string = _collectedStderr.toString();
            _collectedStderr = null;
            Debug.distributeErrorMessage(string);
        }
    }

    static void sendCollectedStreams() {
        Debug.sendCollectedStdout();
        Debug.sendCollectedStderr();
    }

    static void writeStdoutMessage(String string) {
        Debug.sendCollectedStderr();
        int n = string.length();
        if (n > 0) {
            if (string.charAt(n - 1) == '\n') {
                string = string.substring(0, n - 1);
            }
            if (_bufferStreams) {
                if (_collectedStdout == null) {
                    _collectedStdout = new StringBuffer();
                    string = "[STDOUT>\n" + string;
                }
                _collectedStdout.append(string).append('\n');
            } else {
                Debug.sendCollectedStdout();
                Debug.distributeStandardMessage("[STDERR>\n" + string);
            }
        }
    }

    static void writeStderrMessage(String string) {
        Debug.sendCollectedStdout();
        int n = string.length();
        if (n > 0) {
            if (string.charAt(n - 1) == '\n') {
                string = string.substring(0, n - 1);
            }
            if (_bufferStreams) {
                if (_collectedStderr == null) {
                    _collectedStderr = new StringBuffer();
                    string = "[STDERR>\n" + string;
                }
                _collectedStderr.append(string).append('\n');
            } else {
                Debug.sendCollectedStderr();
                Debug.distributeErrorMessage("[STDERR>\n" + string);
            }
        }
    }

    public static void setStdoutCaptureMode(boolean bl) {
        if (bl != Debug.getStdoutCaptureMode()) {
            if (bl) {
                if (!Debug.getStdoutCaptureMode()) {
                    _oldStdout = System.out;
                    System.setOut(new PrintStream(new DebuggingOutputStream(0)));
                }
            } else if (Debug.getStdoutCaptureMode()) {
                Debug.sendCollectedStdout();
                System.setOut(_oldStdout);
                _oldStdout = null;
            }
            Debug.informStdoutCaptureModeListeners(bl);
        }
    }

    public static boolean getStdoutCaptureMode() {
        return _oldStdout != null;
    }

    public static PrintStream getConsoleStdout() {
        return Debug.getStdoutCaptureMode() ? _oldStdout : System.out;
    }

    public static void setStderrCaptureMode(boolean bl) {
        if (bl != Debug.getStderrCaptureMode()) {
            if (bl) {
                if (!Debug.getStderrCaptureMode()) {
                    _oldStderr = System.err;
                    System.setErr(new PrintStream(new DebuggingOutputStream(1)));
                }
            } else if (Debug.getStderrCaptureMode()) {
                Debug.sendCollectedStderr();
                System.setErr(_oldStderr);
                _oldStderr = null;
            }
            Debug.informStderrCaptureModeListeners(bl);
        }
    }

    public static boolean getStderrCaptureMode() {
        return _oldStderr != null;
    }

    public static PrintStream getConsoleStderr() {
        return Debug.getStderrCaptureMode() ? _oldStderr : System.err;
    }

    public static void installCookedOutput(OutputStream outputStream) {
        if (outputStream != null) {
            Debug.addCookedMessageDebugListener(new SimpleOutputtingDebugListener(outputStream));
        }
    }

    public static void installCookedOutput() {
        Debug.installCookedOutput(Debug.getConsoleStdout());
    }

    public static String getObjectInfo(Object object) {
        return ObjectInspector.getInfo(object);
    }

    public static void initFromProperties(long l, boolean bl, boolean bl2) {
        boolean bl3 = Utility.getBooleanParameter("debug.show.window", bl);
        boolean bl4 = Utility.getBooleanParameter("debug.print.console", bl2);
        if (bl3 || bl4) {
            long l2 = 0L;
            String string = Utility.getStringParameter("debug.mask", null);
            if (string != null) {
                StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
                while (stringCharacterIterator.current() != '\uffff') {
                    char c = stringCharacterIterator.current();
                    switch (Character.toUpperCase(c)) {
                        case 'T': {
                            l2 |= 1L;
                            break;
                        }
                        case 'S': {
                            l2 |= 2L;
                            break;
                        }
                        case 'W': {
                            l2 |= 4L;
                            break;
                        }
                        case 'E': {
                            l2 |= 8L;
                            break;
                        }
                        case 'F': {
                            l2 |= 0x10L;
                            break;
                        }
                        case 'L': {
                            l2 |= 0x20L;
                            break;
                        }
                        case 'A': {
                            l2 |= 0x40L;
                        }
                    }
                    stringCharacterIterator.next();
                }
            } else {
                l2 = l & 0x7FL;
            }
            Debug.setMask(l2);
            if (bl3) {
                Debug.createDebugWindow();
            }
            if (bl4) {
                Debug.installCookedOutput();
            }
        } else {
            Debug.setMask(0L);
        }
    }

    public static void initFromProperties(long l) {
        Debug.initFromProperties(l, false, false);
    }

    static {
        Debug.addAnyMessageDebugListener(_cook);
    }

    public static interface ModeChangeListener {
        public void modeChanged(int var1, boolean var2);

        public void stdoutCaptureChanged(boolean var1);

        public void stderrCaptureChanged(boolean var1);
    }
}

