/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.measure;

import java.io.Serializable;

public final class LengthUnit
implements Serializable {
    public static final LengthUnit METER = new LengthUnit(1.0, "meter", "m");
    public static final LengthUnit KILOMETER = new LengthUnit(1000.0, "kilometer", "km");
    public static final LengthUnit DECIMETER = new LengthUnit(0.1, "decimeter", "dm");
    public static final LengthUnit CENTIMETER = new LengthUnit(0.01, "centimeter", "cm");
    public static final LengthUnit MILLIMETER = new LengthUnit(0.001, "millimeter", "mm");
    public static final LengthUnit MICROMETER = new LengthUnit(1.0E-6, "micrometer", "\u00b5m");
    public static final LengthUnit NANOMETER = new LengthUnit(1.0E-9, "nanometer", "nm");
    public static final LengthUnit PICOMETER = new LengthUnit(1.0E-12, "picometer", "pm");
    public static final LengthUnit ANGSTROM = new LengthUnit(1.0E-10, "\u00c5ngstr\u00f8m", "\u00c5");
    public static final LengthUnit INCH = new LengthUnit(0.0254, "inch", "in");
    public static final LengthUnit FOOT = new LengthUnit(0.30479999999999996, "foot", "ft");
    private static final LengthUnit[] UNITS = new LengthUnit[]{METER, KILOMETER, DECIMETER, CENTIMETER, MILLIMETER, MICROMETER, NANOMETER, PICOMETER, ANGSTROM, INCH, FOOT};
    protected double ratio;
    protected String name;
    protected String shortCut;

    public LengthUnit(double d, String string, String string2) {
        this.ratio = d;
        this.name = string;
        this.shortCut = string2;
    }

    public String getShortCut() {
        return this.shortCut;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getShortCut();
    }

    public double meterToUnit(double d) {
        return d / this.ratio;
    }

    public double unitToMeter(double d) {
        return d * this.ratio;
    }

    public double otherToUnit(double d, LengthUnit lengthUnit) {
        return lengthUnit.unitToMeter(d) / this.ratio;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LengthUnit lengthUnit = (LengthUnit)object;
        if (Double.compare(lengthUnit.ratio, this.ratio) != 0) {
            return false;
        }
        if (!this.name.equals(lengthUnit.name)) {
            return false;
        }
        return this.shortCut.equals(lengthUnit.shortCut);
    }

    public int hashCode() {
        long l = this.ratio != 0.0 ? Double.doubleToLongBits(this.ratio) : 0L;
        int n = (int)(l ^ l >>> 32);
        n = 31 * n + this.name.hashCode();
        n = 31 * n + this.shortCut.hashCode();
        return n;
    }

    public static LengthUnit getLengthUnit(String string) {
        for (int i = 0; i < UNITS.length; ++i) {
            if (!UNITS[i].getShortCut().equalsIgnoreCase(string)) continue;
            return UNITS[i];
        }
        return null;
    }
}

