// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.analysis;

import javax.swing.*;
import java.applet.Applet;
import java.awt.*;

/**
 *  Frame used for wrapping the analyss applet component.
 */
public class AnalysisAppletFrame
        extends JFrame
        implements AnalysisAppletDisplay,
                   AnalysisAppletComponent.DumpFileListener
{
  /** The analysis component. */
  private AnalysisAppletComponent appletComponent;

  /**
   * Constructs a new frame that is initially invisible.
   * <p/>
   * This constructor sets the component's locale property to the value
   * returned by <code>JComponent.getDefaultLocale</code>.
   *
   * @param applet the applet running this frame
   * @see java.awt.GraphicsEnvironment#isHeadless
   * @see java.awt.Component#setSize
   * @see java.awt.Component#setVisible
   * @see javax.swing.JComponent#getDefaultLocale
   */
  public AnalysisAppletFrame(Applet applet)
  {
    appletComponent = new AnalysisAppletComponent(applet);
    appletComponent.addDumpFileListener(this);
    setDefaultCloseOperation(HIDE_ON_CLOSE);

    getContentPane().setLayout(new BorderLayout());
    getContentPane().add(appletComponent, BorderLayout.CENTER);
  }

  /**
   * Load a new dump file.
   * Invoke this method from JavaScript as a workaround to bug #6669818.
   *
   * @param dumpFile dump file
   */
  public void showDumpFile(String dumpFile)
  {
    appletComponent.showDumpFile(dumpFile);
    if (!isVisible()) {
      setVisible(true);
    }
    toFront();
  }

  /**
   * Start animation if it is not running.
   */
  public void startAnimation()
  {
    appletComponent.startAnimation();
  }
  
  /**
   * Stop animation if it is running.
   */
  public void stopAnimation()
  {
    appletComponent.stopAnimation();
  }

  /**
   * Called if a new dump file is loaded.
   *
   * @param dumpFile new dump file, maybe <code>null</code> if loading failed
   */
  public void dumpFileLoaded(DumpFile dumpFile)
  {
    StringBuilder b = new StringBuilder("Asteroid Analyzer V");
    b.append(AnalysisApplet.VERSION);
    if (dumpFile != null) {
      b.append(": ").append(dumpFile.getShortInfo());
    }
    setTitle(b.toString());
  }

  /**
   * Shows or hides this component depending on the value of parameter
   * <code>b</code>.
   *
   * @param b if <code>true</code>, shows this component;
   *          otherwise, hides this component
   * @see #isVisible
   * @since JDK1.1
   */
  @Override
  public void setVisible(boolean b)
  {
    super.setVisible(b);
    if (!b) {
      // no need for using up performance if not visible
      stopAnimation();
    }
  }
}
