// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util;

import java.awt.*;

/**
 *  A listener which is used in {@link Utility} as a callback
 *  for exception which occure in the event queue.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public interface EventQueueExceptionListener
{
  /**
   *  Called when an uncaught exception occurs in the AWT event thread.
   *  It may pop up a dialog, print something to the console, end the program
   *  or raise an exception of it's own which then is handled the standard way.
   *  The listeners are called in the AWT thread.
   * 
   *  @param event      the event which raised the exception
   *  @param exception  the uncaught exception
   */
  public void exceptionOccured(AWTEvent event, Throwable exception);
}
