/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.DrawableProvider;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.GameData;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.Glyph;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Text;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameDisplay
extends JComponent
implements FrameListener,
GameData {
    private static final Color TIME_COLOR = new Color(0, 255, 0, 128);
    private static final Point PENDING_SHIPS_POSITION = new Point(160, 852);
    private static final int PENDING_SHIPS_DELTA_X = 20;
    private static final int TIME_BORDER = 2;
    private int baseWidth;
    private FrameInfo frameInfo;
    private AffineTransform trafo;
    private DrawableProvider drawableProvider;
    private int startFrame = -1;
    private boolean showingSessionTime = true;
    private boolean usingAntialising;

    public FrameDisplay(int width) {
        this.baseWidth = width;
        if (width > 0) {
            Dimension size = new Dimension(width, 3 * width / 4);
            this.setMaximumSize(size);
            this.setMinimumSize(size);
            this.setPreferredSize(size);
            this.setSize(size);
            this.calculateScaling();
        } else {
            this.setMinimumSize(new Dimension(200, 150));
            this.setPreferredSize(new Dimension(640, 480));
        }
        this.setOpaque(true);
        this.setDoubleBuffered(true);
    }

    private void calculateScaling() {
        int width = this.baseWidth <= 0 ? Math.min(this.getWidth(), 4 * this.getHeight() / 3) : this.baseWidth;
        int height = 3 * width / 4;
        double scalingX = (double)width / 1045.0;
        double scalingY = (double)(-height) / 789.0;
        this.trafo = AffineTransform.getTranslateInstance(10.0, -906.0);
        this.trafo.preConcatenate(AffineTransform.getScaleInstance(scalingX, scalingY));
    }

    private Dimension getCorrectSize() {
        int width = this.baseWidth <= 0 ? Math.min(this.getWidth(), 4 * this.getHeight() / 3) : this.baseWidth;
        return new Dimension(width, 3 * width / 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        FrameInfo info;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.black);
        Dimension size = this.getCorrectSize();
        g.fillRect(0, 0, size.width, size.height);
        g.setClip(0, 0, size.width, size.height);
        FrameDisplay frameDisplay = this;
        synchronized (frameDisplay) {
            info = this.frameInfo;
        }
        if (info != null) {
            Graphics2D g2 = this.createAsteroidSpaceGraphics(g);
            info.draw(g2);
            if (this.drawableProvider != null) {
                this.drawableProvider.draw(g2, info);
            }
            Graphics2D localG = (Graphics2D)g2.create();
            localG.setColor(Color.gray);
            localG.translate(FrameDisplay.PENDING_SHIPS_POSITION.x, FrameDisplay.PENDING_SHIPS_POSITION.y);
            for (int s = info.getNrShips() - 1; s >= 0; --s) {
                SpaceShip.SHIP_GLYPH.drawAndTranslate(localG, 0.25);
            }
            g2.setColor(Color.gray);
            for (Text txt : info.getTexts()) {
                txt.draw(g2);
            }
            if (info.getScore() >= 100000) {
                int c;
                String score = Integer.toString(info.getScore());
                int prefix = score.length() - 5;
                Glyph zero = Text.getGlyph('0');
                Point pos = new Point(info.isGameRunning() ? SCORE_LOCATION_GAME : SCORE_LOCATION_OTHER);
                int scale = 2;
                Point offset = zero.getOffset();
                pos.x -= prefix * 2 * offset.x;
                Graphics2D localG2 = (Graphics2D)g2.create();
                localG2.translate(pos.x, pos.y);
                for (c = 0; c < prefix; ++c) {
                    Text.getGlyph(score.charAt(c), Text.SPACE_GLYPH).drawAndTranslate(localG2, 2.0);
                }
                while (c < score.length() - 2 && score.charAt(c) == '0') {
                    zero.drawAndTranslate(localG2, 2.0);
                    ++c;
                }
            }
            if (this.showingSessionTime) {
                int duration = this.getSessionTime(info);
                g.setFont(Text.FONT);
                g.setColor(TIME_COLOR);
                String time = String.format("%02d:%02d:%02d", duration / 60 / 60 % 100, duration / 60 % 60, duration % 60);
                Rectangle2D bounds = g.getFontMetrics().getStringBounds(time, g);
                g.drawString(time, (int)((double)size.width - bounds.getWidth() - 2.0), (int)(2.0 - bounds.getMinY()));
            }
        }
    }

    protected Graphics2D createAsteroidSpaceGraphics(Graphics g) {
        if (this.baseWidth == 0) {
            this.calculateScaling();
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.usingAntialising ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, this.usingAntialising ? RenderingHints.VALUE_RENDER_QUALITY : RenderingHints.VALUE_RENDER_SPEED);
        g2.transform(this.trafo);
        return g2;
    }

    protected int getSessionTime(FrameInfo frame) {
        if (frame.isGameRunning()) {
            if ((long)this.startFrame == -1L) {
                this.startFrame = frame.getIndex();
            }
            return (frame.getIndex() - this.startFrame) / 60;
        }
        this.startFrame = frame.getIndex();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void frameReceived(FrameInfo frame) {
        FrameDisplay frameDisplay = this;
        synchronized (frameDisplay) {
            this.frameInfo = frame;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GameObject> pickAt(Point p, int pickRadius) {
        FrameDisplay frameDisplay = this;
        synchronized (frameDisplay) {
            if (this.frameInfo == null) {
                return Collections.emptyList();
            }
        }
        Point min = new Point(p.x - pickRadius, p.y + pickRadius);
        Point max = new Point(p.x + pickRadius, p.y - pickRadius);
        try {
            AffineTransform inverse = new AffineTransform(this.trafo).createInverse();
            inverse.transform(min, min);
            inverse.transform(max, max);
            Rectangle hitRect = new Rectangle(min.x, min.y, max.x - min.x, max.y - min.y);
            FrameDisplay frameDisplay2 = this;
            synchronized (frameDisplay2) {
                return this.frameInfo.getOverlappingObjects(hitRect);
            }
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public FrameInfo getFrameInfo() {
        return this.frameInfo;
    }

    protected AffineTransform getTrafo() {
        return this.trafo;
    }

    public boolean isShowingSessionTime() {
        return this.showingSessionTime;
    }

    public void setShowingSessionTime(boolean showingSessionTime) {
        if (this.showingSessionTime != showingSessionTime) {
            this.showingSessionTime = showingSessionTime;
            this.repaint();
        }
    }

    public boolean isUsingAntialising() {
        return this.usingAntialising;
    }

    public void setUsingAntialising(boolean usingAntialising) {
        if (this.usingAntialising != usingAntialising) {
            this.usingAntialising = usingAntialising;
            this.repaint();
        }
    }

    public DrawableProvider getDrawableProvider() {
        return this.drawableProvider;
    }

    public void setDrawableProvider(DrawableProvider drawableProvider) {
        this.drawableProvider = drawableProvider;
    }
}

