/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;

public class TimedScorePrinter
implements FrameListener {
    public static final int DEFAULT_FRAMES = 18000;
    public static final int NO_FRAME = -1;
    private int printFrame = -1;
    private final int countFrames;
    private int score = 0;

    public TimedScorePrinter() {
        this(18000);
    }

    public TimedScorePrinter(int frames) {
        this.countFrames = frames;
    }

    public void frameReceived(FrameInfo frame) {
        if (!frame.isGameRunning()) {
            this.printFrame = -1;
        } else if (this.printFrame == -1) {
            if (frame.getSpaceShip() != null) {
                this.printFrame = frame.getIndex() + this.countFrames;
            }
        } else if (frame.getIndex() == this.printFrame) {
            this.score = frame.getScore();
            System.out.println(String.format("Score after %d frames: %d", this.countFrames, this.score));
        }
    }

    public int getScore() {
        return this.score;
    }
}

