/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.Buttons;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.GameData;
import de.caff.asteroid.SimpleVelocityPreparer;
import de.caff.asteroid.analysis.AnalysisAppletDisplay;
import de.caff.asteroid.analysis.AnimationListener;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.DumpLoader;
import de.caff.asteroid.analysis.FrameKeyInfo;
import de.caff.asteroid.analysis.FrameKeyInfoDisplay;
import de.caff.asteroid.analysis.ProgressTimeLine;
import de.caff.asteroid.analysis.TimeLine;
import de.caff.i18n.I18n;
import de.caff.util.KnockOffListener;
import de.caff.util.Worker;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AnalysisAppletComponent
extends JPanel
implements AnalysisAppletDisplay,
GameData {
    private static final String CARD_STANDARD = "standard";
    private static final String CARD_PROGRESS = "progress";
    private Applet applet;
    private CardLayout cardLayout;
    private JPanel cardPanel;
    private TimeLine timeLine;
    private ProgressTimeLine progress;
    private MinimalInfo infoLine;
    private Collection<DumpFileListener> dumpFileListeners = new LinkedList<DumpFileListener>();
    private FrameKeyInfoDisplay frameKeyInfoDisplay;

    public AnalysisAppletComponent(Applet applet) {
        this.applet = applet;
        this.timeLine = new TimeLine(null);
        this.progress = new ProgressTimeLine();
        this.infoLine = new MinimalInfo();
        this.timeLine.addFrameListener(this.infoLine);
        this.infoLine.setBorder(BorderFactory.createEtchedBorder());
        this.frameKeyInfoDisplay = new FrameKeyInfoDisplay(this.timeLine, new SimpleVelocityPreparer(), null, true);
        this.frameKeyInfoDisplay.addAnimationListener(this.infoLine);
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add((Component)this.timeLine, CARD_STANDARD);
        this.cardPanel.add((Component)this.progress, CARD_PROGRESS);
        this.setLayout(new BorderLayout());
        this.add((Component)this.cardPanel, "South");
        this.add((Component)this.infoLine, "North");
        this.add(this.frameKeyInfoDisplay);
    }

    public void showDumpFileDirect(final String filename, final boolean autoStart) {
        block2: {
            this.stopAnimation();
            this.frameKeyInfoDisplay.showMessage(I18n.getString("msgLoading"));
            this.timeLine.setDumpFile(null);
            this.infoLine.refreshDumpFileInfo();
            KnockOffListener ko = new KnockOffListener(){

                public void knockedOff(Worker worker) {
                    AnalysisAppletComponent.this.setCursor(Cursor.getDefaultCursor());
                    AnalysisAppletComponent.this.cardLayout.show(AnalysisAppletComponent.this.cardPanel, AnalysisAppletComponent.CARD_STANDARD);
                    try {
                        worker.rethrow();
                        DumpLoader loader = (DumpLoader)worker;
                        AnalysisAppletComponent.this.timeLine.setDumpFile(loader.getDumpFile());
                        AnalysisAppletComponent.this.infoLine.refreshDumpFileInfo();
                        AnalysisAppletComponent.this.applet.getAppletContext().showStatus(I18n.format("msgLoaded", filename));
                        if (autoStart) {
                            AnalysisAppletComponent.this.startAnimation();
                        }
                    }
                    catch (Throwable x) {
                        JOptionPane.showMessageDialog(AnalysisAppletComponent.this, new Object[]{I18n.format("errNoOpen", filename), x.getLocalizedMessage()}, I18n.getString("titleReadError"), 0);
                    }
                    AnalysisAppletComponent.this.frameKeyInfoDisplay.clearMessage();
                    AnalysisAppletComponent.this.informDumpFileListeners(AnalysisAppletComponent.this.timeLine.getDumpFile());
                }
            };
            try {
                URL fileURL = new URL(this.applet.getDocumentBase(), filename);
                DumpLoader worker = new DumpLoader(fileURL.openStream(), filename, ko, this.progress);
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.cardLayout.show(this.cardPanel, CARD_PROGRESS);
                new Thread((Runnable)worker, "Loader").start();
            }
            catch (Throwable e) {
                JOptionPane.showMessageDialog(this, new Object[]{I18n.format("errNoOpen", filename), e.getLocalizedMessage()}, I18n.getString("titleReadError"), 0);
                if (!(e instanceof OutOfMemoryError)) break block2;
                System.out.println(String.format("Free memory:  %10d", Runtime.getRuntime().freeMemory()));
                System.out.println(String.format("Total memory: %10d", Runtime.getRuntime().totalMemory()));
                System.out.println(String.format("Max memory:   %10d", Runtime.getRuntime().maxMemory()));
            }
        }
    }

    public void showDumpFile(final String dumpFile, final boolean autoStart) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnalysisAppletComponent.this.showDumpFileDirect(dumpFile, autoStart);
            }
        });
    }

    public void startAnimation() {
        this.frameKeyInfoDisplay.startAnimation();
    }

    public void stopAnimation() {
        this.frameKeyInfoDisplay.stopAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDumpFileListener(DumpFileListener listener) {
        Collection<DumpFileListener> collection = this.dumpFileListeners;
        synchronized (collection) {
            this.dumpFileListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDumpFileListener(DumpFileListener listener) {
        Collection<DumpFileListener> collection = this.dumpFileListeners;
        synchronized (collection) {
            return this.dumpFileListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informDumpFileListeners(DumpFile dumpFile) {
        ArrayList<DumpFileListener> listeners;
        Collection<DumpFileListener> collection = this.dumpFileListeners;
        synchronized (collection) {
            listeners = new ArrayList<DumpFileListener>(this.dumpFileListeners);
        }
        for (DumpFileListener listener : listeners) {
            listener.dumpFileLoaded(dumpFile);
        }
    }

    static {
        I18n.addAppResourceBase("de.caff.asteroid.analysis.resources.AnalysisAppletComponent");
    }

    private class MinimalInfo
    extends JPanel
    implements FrameListener,
    AnimationListener {
        private JLabel fileInfo;
        private JLabel frameInfo;
        private JLabel keyInfo;
        private boolean displayKeys;

        MinimalInfo() {
            super(new BorderLayout());
            this.fileInfo = new JLabel();
            this.frameInfo = new JLabel();
            this.keyInfo = new JLabel();
            this.displayKeys = true;
            Box box = Box.createHorizontalBox();
            box.add(this.fileInfo);
            box.add(this.frameInfo);
            box.add(Box.createHorizontalGlue());
            box.add(this.keyInfo);
            this.add((Component)box, "Center");
        }

        public void frameReceived(FrameInfo frame) {
            if (frame == null) {
                this.frameInfo.setText("???");
                this.keyInfo.setText("???");
            } else {
                this.frameInfo.setText(String.format(" #%d", frame.getIndex()));
                if (!this.displayKeys) {
                    this.keyInfo.setText("[ANIM]");
                } else {
                    FrameKeyInfo info = AnalysisAppletComponent.this.timeLine.getCurrentInfo();
                    List<FrameKeyInfo.ButtonInfo> buttons = info.getButtons();
                    StringBuilder b = new StringBuilder();
                    if (!buttons.isEmpty()) {
                        Buttons keys = buttons.get(buttons.size() - 1).getButtons();
                        if (keys.isFirePressed()) {
                            b.append("<FIRE>");
                        }
                        if (keys.isHyperspacePressed()) {
                            b.append("<HYPER>");
                        }
                        if (keys.isThrustPressed()) {
                            b.append("<THRUST>");
                        }
                        if (keys.isLeftPressed()) {
                            b.append("<LEFT>");
                        }
                        if (keys.isRightPressed()) {
                            b.append("<RIGHT>");
                        }
                        if (keys.isStartPressed()) {
                            b.append("<START>");
                        }
                    }
                    this.keyInfo.setText(b.length() == 0 ? "<>" : b.toString());
                }
            }
        }

        void refreshDumpFileInfo() {
            DumpFile dumpFile = AnalysisAppletComponent.this.timeLine.getDumpFile();
            if (dumpFile == null) {
                this.fileInfo.setText("???");
                this.frameReceived(null);
            } else {
                this.fileInfo.setText(dumpFile.getShortInfo());
                this.frameReceived(AnalysisAppletComponent.this.timeLine.getCurrentInfo().getFrameInfo());
            }
        }

        public synchronized void animationStarting() {
            this.displayKeys = false;
        }

        public synchronized void animationEnded() {
            this.displayKeys = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MinimalInfo.this.refreshDumpFileInfo();
                }
            });
        }
    }

    public static interface DumpFileListener {
        public void dumpFileLoaded(DumpFile var1);
    }
}

