/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.gimmicks.swing.AbstractState;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.util.Utility;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class VisibleState
extends AbstractState
implements Localizable {
    private static final String LABEL_RESOURCE_KEY_PROPERTY = "LABEL_RESOURCE_KEY";
    private static final String TOOLTIP_RESOURCE_KEY_PROPERTY = "TOOLTIP_RESOURCE_KEY";
    private Locale locale;

    public VisibleState(String labelResourceKey, String tooltipResourceKey, Icon activeIcon, Icon inactiveIcon, Icon disabledIcon) {
        this.init(labelResourceKey, tooltipResourceKey, activeIcon, inactiveIcon, disabledIcon);
    }

    private void init(String labelResourceKey, String tooltipResourceKey, Icon activeIcon, Icon inactiveIcon, Icon disabledIcon) {
        this.setProperty(LABEL_RESOURCE_KEY_PROPERTY, labelResourceKey);
        this.setProperty(TOOLTIP_RESOURCE_KEY_PROPERTY, tooltipResourceKey);
        this.setProperty("ACTIVE_ICON", activeIcon);
        this.setProperty("INACTIVE_ICON", inactiveIcon);
        this.setProperty("DISABLED_ICON", disabledIcon);
        I18n.addLocalizationChangeListener(this);
        this.setLocale(I18n.getDefaultLocale());
    }

    public VisibleState(String labelResourceKey, String tooltipResourceKey, Icon activeIcon) {
        this(labelResourceKey, tooltipResourceKey, activeIcon, activeIcon, null);
    }

    public VisibleState(String baseTag) {
        ImageIcon normal;
        ImageIcon disabled = normal = new ImageIcon(Utility.loadImage(I18n.getString(baseTag + "-ICON")));
        ImageIcon inactive = null;
        try {
            disabled = new ImageIcon(Utility.loadImage(I18n.getString(baseTag + "-ICON-DIS")));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            inactive = new ImageIcon(Utility.loadImage(I18n.getString(baseTag + "-ICON-INACT")));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        this.init(baseTag + "-TEXT", baseTag + "-TTT", normal, disabled, inactive);
    }

    public void setLocale(Locale l) {
        this.locale = l;
        Object key = this.getValue(LABEL_RESOURCE_KEY_PROPERTY);
        if (key != null) {
            this.setProperty("LABEL_TEXT", I18n.getString(key.toString(), l));
        }
        if ((key = this.getValue(TOOLTIP_RESOURCE_KEY_PROPERTY)) != null) {
            this.setProperty("TOOLTIP_TEXT", I18n.getString(key.toString(), l));
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void finalize() {
        I18n.removeLocalizationChangeListener(this);
    }
}

