/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.i18n.I18n;
import de.caff.util.AbstractBasicStatusFlag;
import java.util.Locale;

public class LongStatusFlag
extends AbstractBasicStatusFlag {
    private final long bitValue;

    public LongStatusFlag(int n, String string) {
        super(string);
        if (n < 0 || n > 63) {
            throw new IllegalArgumentException("Argument p has to be between 0 and 63, but " + n + " is used!");
        }
        this.bitValue = 1L << n;
    }

    public long getBitValue() {
        return this.bitValue;
    }

    public String getI18nTag(long l) {
        return this.getI18nTag(this.isSetIn(l));
    }

    public String getDescription(long l) {
        return I18n.getString(this.getI18nTag(l));
    }

    public String getDescription(long l, Locale locale) {
        return I18n.getString(this.getI18nTag(l), locale);
    }

    public boolean isSetIn(long l) {
        return (l & this.bitValue) != 0L;
    }

    public long setFlagIn(long l) {
        return l | this.bitValue;
    }

    public long clearFlagIn(long l) {
        return l & (this.bitValue ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

