/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.util.KnockOffListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class Worker
implements Runnable {
    private static ThreadGroup WORKER_THREAD_GROUP = new ThreadGroup("de.caff.util.Worker"){};
    private Throwable catched;
    private List knockOffListeners = new LinkedList();
    private boolean stopped = false;

    public Worker() {
    }

    public Worker(KnockOffListener knockOffListener) {
        this.addKnockOffListener(knockOffListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.execute();
        }
        catch (Throwable throwable) {
            this.catched = throwable;
        }
        finally {
            this.informKnockOffListeners();
        }
    }

    protected abstract void execute() throws Throwable;

    public Throwable getCatched() {
        return this.catched;
    }

    public void rethrow() throws Throwable {
        if (this.catched != null) {
            throw this.catched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKnockOffListener(KnockOffListener knockOffListener) {
        if (knockOffListener != null) {
            List list = this.knockOffListeners;
            synchronized (list) {
                this.knockOffListeners.add(knockOffListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKnockOffListener(KnockOffListener knockOffListener) {
        if (knockOffListener != null) {
            List list = this.knockOffListeners;
            synchronized (list) {
                this.knockOffListeners.remove(knockOffListener);
            }
        }
    }

    protected void informKnockOffListeners() {
        Worker.invokeInEventDispatchThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList arrayList;
                Object object = Worker.this.knockOffListeners;
                synchronized (object) {
                    arrayList = new ArrayList(Worker.this.knockOffListeners);
                }
                object = arrayList.iterator();
                while (object.hasNext()) {
                    KnockOffListener knockOffListener = (KnockOffListener)object.next();
                    knockOffListener.knockedOff(Worker.this);
                }
            }
        });
    }

    public void stop() {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean bl) {
        Object object;
        if (bl) {
            object = this.knockOffListeners;
            synchronized (object) {
                this.knockOffListeners.clear();
            }
        }
        object = this;
        synchronized (object) {
            this.stopped = true;
        }
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public static void invokeInEventDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

