/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import java.lang.reflect.Field;

public class ObjectInspector {
    static String getInfo(Object object) {
        try {
            Class<?> clazz = object.getClass();
            String string = "Object: " + clazz.getName() + '@' + Integer.toHexString(object.hashCode()) + '\n';
            string = string + ObjectInspector.getFields(clazz, object);
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getFields(Class clazz, Object object) {
        StringBuffer stringBuffer = new StringBuffer("{\n");
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            stringBuffer.append('\t').append(fieldArray[i].toString()).append(" = ").append(ObjectInspector.getValue(fieldArray[i], object)).append(";\n");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getValue(Field field, Object object) {
        try {
            field.setAccessible(true);
            StringBuffer stringBuffer = new StringBuffer();
            Class<?> clazz = field.getType();
            if (clazz.isPrimitive()) {
                if (clazz == Integer.TYPE) {
                    stringBuffer.append(field.getInt(object));
                } else if (clazz == Boolean.TYPE) {
                    stringBuffer.append(field.getBoolean(object));
                } else if (clazz == Byte.TYPE) {
                    stringBuffer.append(field.getByte(object));
                } else if (clazz == Short.TYPE) {
                    stringBuffer.append(field.getShort(object));
                } else if (clazz == Long.TYPE) {
                    stringBuffer.append(field.getLong(object));
                } else if (clazz == Float.TYPE) {
                    stringBuffer.append(field.getFloat(object));
                } else if (clazz == Double.TYPE) {
                    stringBuffer.append(field.getDouble(object));
                }
            } else {
                stringBuffer.append(field.get(object));
            }
            return stringBuffer.toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            return "?";
        }
        catch (SecurityException securityException) {
            return "?";
        }
    }
}

