/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.measure;

import de.caff.util.PrintfFormat;
import de.caff.util.measure.IllegalPhysicalLengthFormatException;
import de.caff.util.measure.LengthUnit;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public final class PhysicalLength
implements Serializable {
    public static final PrintfFormat unitFormat = new PrintfFormat("%.2lf");
    private final double length;
    public static final PhysicalLength NULL = new PhysicalLength(0.0);

    private PhysicalLength(double d) {
        this.length = d;
    }

    public PhysicalLength(double d, LengthUnit lengthUnit) {
        this(lengthUnit.unitToMeter(d));
    }

    public double getLength() {
        return this.length;
    }

    public double getLength(LengthUnit lengthUnit) {
        return lengthUnit.meterToUnit(this.getLength());
    }

    public String toString() {
        return unitFormat.sprintf(this.getLength()) + " " + LengthUnit.METER;
    }

    public String toString(LengthUnit lengthUnit) {
        return unitFormat.sprintf(this.getLength(lengthUnit)) + " " + lengthUnit;
    }

    public boolean equals(PhysicalLength physicalLength, PhysicalLength physicalLength2) {
        return Math.abs(physicalLength.length - this.length) <= physicalLength2.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PhysicalLength physicalLength = (PhysicalLength)object;
        return this.equals(physicalLength, NULL);
    }

    public int hashCode() {
        long l = this.length != 0.0 ? Double.doubleToLongBits(this.length) : 0L;
        return (int)(l ^ l >>> 32);
    }

    public PhysicalLength times(double d) {
        return new PhysicalLength(this.length * d);
    }

    public PhysicalLength dividedBy(double d) {
        return new PhysicalLength(this.length / d);
    }

    public PhysicalLength plus(PhysicalLength physicalLength) {
        return new PhysicalLength(this.length + physicalLength.length);
    }

    public PhysicalLength minus(PhysicalLength physicalLength) {
        return new PhysicalLength(this.length - physicalLength.length);
    }

    public static PhysicalLength fromString(String string, Locale locale) throws IllegalPhysicalLengthFormatException {
        if ((string = string.trim()).length() < 2) {
            throw new IllegalPhysicalLengthFormatException("String too short to contain valid physical length: " + string);
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = numberFormat.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new IllegalPhysicalLengthFormatException("String does not start with a valid floating point number for locale " + locale + ": " + string);
        }
        LengthUnit lengthUnit = LengthUnit.getLengthUnit(string.substring(parsePosition.getIndex()).trim());
        if (lengthUnit == null) {
            throw new IllegalPhysicalLengthFormatException("Unknown length unit: " + lengthUnit);
        }
        return new PhysicalLength(number.doubleValue(), lengthUnit);
    }

    public static PhysicalLength fromString(String string) throws IllegalPhysicalLengthFormatException {
        return PhysicalLength.fromString(string, Locale.getDefault());
    }
}

