/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.print;

import de.caff.util.measure.LengthUnit;
import de.caff.util.measure.PhysicalLength;
import de.caff.util.print.PaperFormat;
import java.awt.print.Paper;
import java.io.Serializable;

public class BasicPaperFormat
implements PaperFormat,
Serializable {
    public static final Orientation ORIENTATION_PORTRAIT = new Orientation(0, "portrait");
    public static final Orientation ORIENTATION_LANDSCAPE = new Orientation(90, "landscape");
    public static final Orientation ORIENTATION_UPSIDE_DOWN = new Orientation(180, "upside-down");
    public static final Orientation ORIENTATION_SEASCAPE = new Orientation(270, "seascape");
    public static final LengthUnit AWT_POINTS = new LengthUnit(3.5277777777777776E-4, "AWT point", "AWT pt");
    public static final PhysicalLength DEFAULT_MARGIN = new PhysicalLength(10.0, LengthUnit.MILLIMETER);
    public static final BasicPaperFormat A4_PAPER = new BasicPaperFormat("A4", 210.0, 297.0);
    public static final BasicPaperFormat A3_PAPER = new BasicPaperFormat("A3", 297.0, 420.0);
    public static final BasicPaperFormat A2_PAPER = new BasicPaperFormat("A2", 420.0, 595.0);
    public static final BasicPaperFormat A1_PAPER = new BasicPaperFormat("A1", 595.0, 841.0);
    public static final BasicPaperFormat A0_PAPER = new BasicPaperFormat("A0", 841.0, 1189.0);
    public static final BasicPaperFormat B5_PAPER = new BasicPaperFormat("B5", 176.0, 250.0);
    public static final BasicPaperFormat B4_PAPER = new BasicPaperFormat("B4", 250.0, 353.0);
    public static final BasicPaperFormat B3_PAPER = new BasicPaperFormat("B3", 353.0, 500.0);
    public static final BasicPaperFormat B2_PAPER = new BasicPaperFormat("B2", 500.0, 707.0);
    public static final BasicPaperFormat B1_PAPER = new BasicPaperFormat("B1", 707.0, 1000.0);
    public static final BasicPaperFormat B0_PAPER = new BasicPaperFormat("B0", 1000.0, 1414.0);
    public static final BasicPaperFormat LETTER_PAPER = new BasicPaperFormat("Letter", 216.0, 279.0);
    public static final BasicPaperFormat LEGAL_PAPER = new BasicPaperFormat("Legal", 216.0, 356.0);
    public static final BasicPaperFormat EXECUTIVE_PAPER = new BasicPaperFormat("Executive", 190.0, 254.0);
    public static final BasicPaperFormat TABLOID_PAPER = new BasicPaperFormat("Tabloid", 279.0, 432.0);
    private static final BasicPaperFormat[] PAPER_FORMATS = new BasicPaperFormat[]{A4_PAPER, A3_PAPER, A2_PAPER, A1_PAPER, A0_PAPER, B5_PAPER, B4_PAPER, B3_PAPER, B2_PAPER, B1_PAPER, B0_PAPER, LETTER_PAPER, LEGAL_PAPER, EXECUTIVE_PAPER, TABLOID_PAPER};
    private final PhysicalLength width;
    private final PhysicalLength height;
    private final PhysicalLength leftMargin;
    private final PhysicalLength rightMargin;
    private final PhysicalLength topMargin;
    private final PhysicalLength bottomMargin;
    private String name;

    protected BasicPaperFormat(String string, double d, double d2) {
        this(new PhysicalLength(d, LengthUnit.MILLIMETER), new PhysicalLength(d2, LengthUnit.MILLIMETER), DEFAULT_MARGIN);
        this.name = string;
    }

    public BasicPaperFormat(String string, PaperFormat paperFormat, Orientation orientation) {
        if (orientation == ORIENTATION_LANDSCAPE) {
            this.width = paperFormat.getHeight();
            this.height = paperFormat.getWidth();
            this.leftMargin = paperFormat.getTopMargin();
            this.rightMargin = paperFormat.getBottomMargin();
            this.topMargin = paperFormat.getRightMargin();
            this.bottomMargin = paperFormat.getLeftMargin();
        } else if (orientation == ORIENTATION_SEASCAPE) {
            this.width = paperFormat.getHeight();
            this.height = paperFormat.getWidth();
            this.leftMargin = paperFormat.getBottomMargin();
            this.rightMargin = paperFormat.getTopMargin();
            this.topMargin = paperFormat.getLeftMargin();
            this.bottomMargin = paperFormat.getRightMargin();
        } else if (orientation == ORIENTATION_UPSIDE_DOWN) {
            this.width = paperFormat.getWidth();
            this.height = paperFormat.getHeight();
            this.leftMargin = paperFormat.getRightMargin();
            this.rightMargin = paperFormat.getLeftMargin();
            this.topMargin = paperFormat.getBottomMargin();
            this.bottomMargin = paperFormat.getTopMargin();
        } else {
            this.width = paperFormat.getWidth();
            this.height = paperFormat.getHeight();
            this.leftMargin = paperFormat.getLeftMargin();
            this.rightMargin = paperFormat.getRightMargin();
            this.topMargin = paperFormat.getTopMargin();
            this.bottomMargin = paperFormat.getBottomMargin();
        }
        this.name = string;
    }

    public BasicPaperFormat(PhysicalLength physicalLength, PhysicalLength physicalLength2, PhysicalLength physicalLength3) {
        this(physicalLength, physicalLength2, physicalLength3, physicalLength3, physicalLength3, physicalLength3);
    }

    public BasicPaperFormat(PhysicalLength physicalLength, PhysicalLength physicalLength2, PhysicalLength physicalLength3, PhysicalLength physicalLength4, PhysicalLength physicalLength5, PhysicalLength physicalLength6) {
        this.width = physicalLength;
        this.height = physicalLength2;
        this.leftMargin = physicalLength3;
        this.rightMargin = physicalLength4;
        this.topMargin = physicalLength5;
        this.bottomMargin = physicalLength6;
    }

    public BasicPaperFormat(PaperFormat paperFormat, PhysicalLength physicalLength, PhysicalLength physicalLength2, PhysicalLength physicalLength3, PhysicalLength physicalLength4) {
        this(paperFormat.getWidth(), paperFormat.getHeight(), physicalLength, physicalLength2, physicalLength3, physicalLength4);
        if (paperFormat instanceof BasicPaperFormat) {
            this.name = ((BasicPaperFormat)paperFormat).name;
        }
    }

    public PhysicalLength getWidth() {
        return this.width;
    }

    public PhysicalLength getHeight() {
        return this.height;
    }

    public PhysicalLength getLeftMargin() {
        return this.leftMargin;
    }

    public PhysicalLength getRightMargin() {
        return this.rightMargin;
    }

    public PhysicalLength getTopMargin() {
        return this.topMargin;
    }

    public PhysicalLength getBottomMargin() {
        return this.bottomMargin;
    }

    public String getName() {
        return this.name;
    }

    public static PhysicalLength getInnerWidth(PaperFormat paperFormat) {
        return paperFormat.getWidth().minus(paperFormat.getLeftMargin()).minus(paperFormat.getRightMargin());
    }

    public static PhysicalLength getInnerHeight(PaperFormat paperFormat) {
        return paperFormat.getHeight().minus(paperFormat.getTopMargin()).minus(paperFormat.getBottomMargin());
    }

    public PaperFormat toLandScape() {
        return new BasicPaperFormat(this.name + " (" + ORIENTATION_LANDSCAPE + ")", this, ORIENTATION_LANDSCAPE);
    }

    public PaperFormat toSeaScape() {
        return new BasicPaperFormat(this.name + " (" + ORIENTATION_SEASCAPE + ")", this, ORIENTATION_SEASCAPE);
    }

    public PaperFormat toUpsideDown() {
        return new BasicPaperFormat(this.name + " (" + ORIENTATION_UPSIDE_DOWN + ")", this, ORIENTATION_UPSIDE_DOWN);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicPaperFormat basicPaperFormat = (BasicPaperFormat)object;
        if (!this.bottomMargin.equals(basicPaperFormat.bottomMargin)) {
            return false;
        }
        if (!this.height.equals(basicPaperFormat.height)) {
            return false;
        }
        if (!this.leftMargin.equals(basicPaperFormat.leftMargin)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(basicPaperFormat.name) : basicPaperFormat.name != null) {
            return false;
        }
        if (!this.rightMargin.equals(basicPaperFormat.rightMargin)) {
            return false;
        }
        if (!this.topMargin.equals(basicPaperFormat.topMargin)) {
            return false;
        }
        return this.width.equals(basicPaperFormat.width);
    }

    public int hashCode() {
        int n = this.width.hashCode();
        n = 31 * n + this.height.hashCode();
        n = 31 * n + this.leftMargin.hashCode();
        n = 31 * n + this.rightMargin.hashCode();
        n = 31 * n + this.topMargin.hashCode();
        n = 31 * n + this.bottomMargin.hashCode();
        n = 31 * n + (this.name != null ? this.name.hashCode() : 0);
        return n;
    }

    public boolean equalSized(PaperFormat paperFormat) {
        return this.width.equals(paperFormat.getWidth()) && this.height.equals(paperFormat.getHeight()) && this.leftMargin.equals(paperFormat.getLeftMargin()) && this.rightMargin.equals(paperFormat.getRightMargin()) && this.topMargin.equals(paperFormat.getTopMargin()) && this.bottomMargin.equals(paperFormat.getBottomMargin());
    }

    public static PaperFormat getPaperFormat(String string) {
        if (string != null) {
            if (string.startsWith("DIN")) {
                string = string.substring(3).trim();
            }
            for (int i = 0; i < PAPER_FORMATS.length; ++i) {
                if (!PAPER_FORMATS[i].getName().equalsIgnoreCase(string)) continue;
                return PAPER_FORMATS[i];
            }
        }
        return null;
    }

    public static Paper toPaper(PaperFormat paperFormat) {
        Paper paper = new Paper();
        paper.setSize(paperFormat.getHeight().getLength(AWT_POINTS), paperFormat.getWidth().getLength(AWT_POINTS));
        paper.setImageableArea(paperFormat.getLeftMargin().getLength(AWT_POINTS), paperFormat.getTopMargin().getLength(AWT_POINTS), BasicPaperFormat.getInnerWidth(paperFormat).getLength(AWT_POINTS), BasicPaperFormat.getInnerHeight(paperFormat).getLength(AWT_POINTS));
        return paper;
    }

    public static BasicPaperFormat toPaperFormat(Paper paper) {
        return new BasicPaperFormat(new PhysicalLength(paper.getWidth(), AWT_POINTS), new PhysicalLength(paper.getHeight(), AWT_POINTS), new PhysicalLength(paper.getImageableX(), AWT_POINTS), new PhysicalLength(paper.getWidth() - paper.getImageableX() - paper.getImageableWidth(), AWT_POINTS), new PhysicalLength(paper.getImageableY(), AWT_POINTS), new PhysicalLength(paper.getHeight() - paper.getImageableY() - paper.getImageableHeight(), AWT_POINTS));
    }

    private static class Orientation {
        private final int degrees;
        private final String name;

        private Orientation(int n, String string) {
            this.degrees = n;
            this.name = string;
        }

        public int getDegrees() {
            return this.degrees;
        }

        public String toString() {
            return this.name;
        }
    }
}

