/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.i18n.I18n;
import de.caff.util.AbstractBasicStatusFlag;
import java.util.Locale;

public class IntStatusFlag
extends AbstractBasicStatusFlag {
    private final int bitValue;

    public IntStatusFlag(int n, String string) {
        super(string);
        if (n < 0 || n > 31) {
            throw new IllegalArgumentException("Argument p has to be between 0 and 31, but " + n + " is used!");
        }
        this.bitValue = 1 << n;
    }

    public int getBitValue() {
        return this.bitValue;
    }

    public String getI18nTag(int n) {
        return this.getI18nTag(this.isSetIn(n));
    }

    public String getDescription(int n) {
        return I18n.getString(this.getI18nTag(n));
    }

    public String getDescription(int n, Locale locale) {
        return I18n.getString(this.getI18nTag(n), locale);
    }

    public boolean isSetIn(int n) {
        return (n & this.bitValue) != 0;
    }

    public int setFlagIn(int n) {
        return n | this.bitValue;
    }

    public int clearFlagIn(int n) {
        return n & ~this.bitValue;
    }
}

