/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.util.debug.CookedMessageDebugListener;
import de.caff.util.debug.Debug;
import de.caff.util.debug.DebugLevelSwitchBoard;
import de.caff.util.debug.DebugMessageCook;
import de.caff.util.debug.MemoryUsagePanel;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DebugMessageWindow
extends JFrame
implements CookedMessageDebugListener {
    private JTextArea _msgArea;
    private int _endPos;

    public DebugMessageWindow(boolean bl) {
        super("Debug Messages");
        JComponent jComponent;
        JPanel jPanel;
        this.setDefaultCloseOperation(0);
        this._msgArea = new JTextArea(25, 100);
        this._msgArea.setFont(new Font("Monospaced", 0, 12));
        this._msgArea.setEditable(false);
        this.getContentPane().add(new JScrollPane(this._msgArea));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.getContentPane().add("East", jPanel2);
        if (bl) {
            jPanel = new MemoryUsagePanel();
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Memory"));
            jPanel2.add("North", jPanel);
            jComponent = new DebugLevelSwitchBoard();
            jPanel2.add("Center", jComponent);
            jComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Global Settings"));
            jPanel2.add(jComponent);
        }
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add("South", jPanel);
        jComponent = new JButton("Print System Properties");
        jPanel.add("North", jComponent);
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DebugMessageWindow.this.printProperties();
            }
        });
        jComponent.setToolTipText("Print the system properties in the text window");
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
        jPanel.add("South", jPanel3);
        jComponent = new JButton("Clear");
        jPanel3.add(jComponent);
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DebugMessageWindow.this.clear();
            }
        });
        jComponent.setToolTipText("Clears the text window");
        jComponent = new JButton("Save...");
        jPanel3.add(jComponent);
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DebugMessageWindow.this.save();
            }
        });
        jComponent.setToolTipText("Allows to save the content of the text window");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Debug.removeCookedMessageDebugListener(DebugMessageWindow.this);
                DebugMessageWindow.this.dispose();
            }
        });
        Debug.addCookedMessageDebugListener(this);
        this.pack();
        this.setVisible(true);
    }

    public void receiveCookedMessage(int n, final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DebugMessageWindow.this.append(string + DebugMessageCook.cookedPosition(string2));
            }
        });
    }

    private void append(String string) {
        this._msgArea.append(string);
        this._endPos += string.length();
        this._msgArea.setCaretPosition(this._endPos);
    }

    private void clear() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DebugMessageWindow.this._msgArea.setText("");
                DebugMessageWindow.this._endPos = 0;
            }
        });
    }

    private void save() {
        JFileChooser jFileChooser = new JFileChooser();
        if (jFileChooser.showDialog(this, "Sichern") == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(this._msgArea.getText());
                fileWriter.close();
                Debug.message("Debugmeldungen gesichert in \"%1\"", file);
            }
            catch (Exception exception) {
                Debug.error("Sichern von \"%1\" gescheitert.\nGrund:\n%2", file, exception.getMessage());
            }
        }
    }

    private void printProperties() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = System.getProperties().propertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            try {
                arrayList.add("\t" + string + " = \"" + System.getProperty(string) + "\"\n");
            }
            catch (SecurityException securityException) {
                arrayList.add("\t" + string + " not available due to security restrictions\n");
            }
        }
        Collections.sort(arrayList);
        this.append("SYSTEM PROPERTIES:\n");
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.append(object.next().toString());
        }
    }
}

