/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

public class Format {
    private static final String NULL_STRING = "<null>";

    public static String format(Object object, Object[] objectArray) {
        String string = object.toString();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                bl = false;
                if ('1' <= c && c <= '9') {
                    int n2 = c - 49;
                    if (n2 >= objectArray.length) {
                        stringBuffer.append("<%").append(c).append(" missing>");
                        continue;
                    }
                    stringBuffer.append(Format.toString(objectArray[n2]));
                    continue;
                }
                if (c == '%') {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append('%').append(c);
                continue;
            }
            if (c == '%') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String format(Object object, Object object2) {
        return Format.format(object, new Object[]{object2});
    }

    public static String format(Object object, Object object2, Object object3) {
        return Format.format(object, new Object[]{object2, object3});
    }

    public static String format(Object object, Object object2, Object object3, Object object4) {
        return Format.format(object, new Object[]{object2, object3, object4});
    }

    public static String format(Object object, Object object2, Object object3, Object object4, Object object5) {
        return Format.format(object, new Object[]{object2, object3, object4, object5});
    }

    public static String format(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return Format.format(object, new Object[]{object2, object3, object4, object5, object6});
    }

    public static String format(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return Format.format(object, new Object[]{object2, object3, object4, object5, object6, object7});
    }

    public static String format(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return Format.format(object, new Object[]{object2, object3, object4, object5, object6, object7, object8});
    }

    public static String format(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return Format.format(object, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9});
    }

    public static String format(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return Format.format(object, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9, object10});
    }

    public static String toString(Object object) {
        return Format.toString(object, "{", ",", "}", "");
    }

    private static String toString(Object object, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object == null) {
            return NULL_STRING;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            stringBuffer.append(string);
            if (clazz.getComponentType().isPrimitive()) {
                Class<?> clazz2 = clazz.getComponentType();
                if (clazz2 == Integer.TYPE) {
                    int[] nArray = (int[])object;
                    for (int i = 0; i < nArray.length; ++i) {
                        stringBuffer.append(nArray[i]);
                        if (i == nArray.length - 1) continue;
                        stringBuffer.append(string2);
                    }
                } else if (clazz2 == Short.TYPE) {
                    short[] sArray = (short[])object;
                    for (int i = 0; i < sArray.length; ++i) {
                        stringBuffer.append(sArray[i]);
                        if (i == sArray.length - 1) continue;
                        stringBuffer.append(string2);
                    }
                } else if (clazz2 == Byte.TYPE) {
                    byte[] byArray = (byte[])object;
                    for (int i = 0; i < byArray.length; ++i) {
                        stringBuffer.append(byArray[i]);
                        if (i == byArray.length - 1) continue;
                        stringBuffer.append(string2);
                    }
                } else if (clazz2 == Long.TYPE) {
                    long[] lArray = (long[])object;
                    for (int i = 0; i < lArray.length; ++i) {
                        stringBuffer.append(lArray[i]);
                        if (i == lArray.length - 1) continue;
                        stringBuffer.append(string2);
                    }
                } else if (clazz2 == Character.TYPE) {
                    char[] cArray = (char[])object;
                    for (int i = 0; i < cArray.length; ++i) {
                        stringBuffer.append(cArray[i]);
                        if (i == cArray.length - 1) continue;
                        stringBuffer.append(string2);
                    }
                } else if (clazz2 == Boolean.TYPE) {
                    boolean[] blArray = (boolean[])object;
                    for (int i = 0; i < blArray.length; ++i) {
                        stringBuffer.append(blArray[i]);
                        if (i == blArray.length - 1) continue;
                        stringBuffer.append(string2);
                    }
                } else if (clazz2 == Float.TYPE) {
                    float[] fArray = (float[])object;
                    for (int i = 0; i < fArray.length; ++i) {
                        stringBuffer.append(fArray[i]);
                        if (i == fArray.length - 1) continue;
                        stringBuffer.append(string2);
                    }
                } else if (clazz2 == Double.TYPE) {
                    double[] dArray = (double[])object;
                    for (int i = 0; i < dArray.length; ++i) {
                        stringBuffer.append(dArray[i]);
                        if (i == dArray.length - 1) continue;
                        stringBuffer.append(string2);
                    }
                }
            } else {
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(Format.toString(objectArray[i], string4 + string, string4 + string2, string4 + string3, string4));
                    if (i == objectArray.length - 1) continue;
                    stringBuffer.append(string2);
                }
            }
            stringBuffer.append(string3);
            return stringBuffer.toString();
        }
        return object.toString();
    }

    public static int getMaxStringLength(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= n) continue;
            n = stringArray[i].length();
        }
        return n;
    }

    public static String rpad(String string, int n, String string2) {
        if (string2.length() > 0) {
            while (string.length() < n) {
                string = string + string2;
            }
        }
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String lpad(String string, int n, String string2) {
        if (string2.length() > 0) {
            while (string.length() < n) {
                string = string2 + string;
            }
        }
        if (string.length() > n) {
            string = string.substring(string.length() - n, n + 1);
        }
        return string;
    }

    public static String center(String string, int n, String string2) {
        int n2 = (n - string.length()) / 2;
        return Format.lpad(string, string.length() + n2, string2);
    }

    public static String replace(String string, String string2, String string3) {
        String string4 = "";
        if (string != null && string2 != null && string3 != null && string2 != "") {
            String[] stringArray = new String[string.length()];
            int n = 0;
            while (string.indexOf(string2) >= 0) {
                stringArray[n++] = string.substring(0, string.indexOf(string2));
                string = string.substring(string.indexOf(string2) + string2.length());
            }
            for (int i = 0; i < n; ++i) {
                string4 = string4 + stringArray[i] + string3;
            }
            string4 = string4 + string;
        }
        return string4;
    }

    public static String trimLeft(String string) {
        char c;
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && (Character.isWhitespace(c = string.charAt(n)) || Character.isISOControl(c)); ++n) {
        }
        return string.substring(n, n2);
    }

    public static String trimRight(String string) {
        char c;
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        for (n = n2 - 1; n >= 0 && (Character.isWhitespace(c = string.charAt(n)) || Character.isISOControl(c)); --n) {
        }
        return string.substring(0, n + 1);
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{1, 2, 3};
        String[][] stringArrayArray = new String[][]{{"eins1", "eins2", "eins3"}, {"zwei1", "zwei2", "zwei3"}, {"drei1", "drei2", "drei3"}, null};
        System.out.println(Format.format((Object)"Integer array: %1", (Object)nArray));
        System.out.println(Format.toString(stringArrayArray, "{\n  ", ",\n  ", "\n}", "  "));
        if (!"abcxx".equals(Format.rpad("abc", 5, "x"))) {
            System.out.println("rpad has an error (1)");
        }
        if (!"abcxx".equals(Format.rpad("abc", 5, "xx"))) {
            System.out.println("rpad has an error (2)");
        }
        if (!"abcxx".equals(Format.rpad("abc", 5, "xxxx"))) {
            System.out.println("rpad has an error (3)");
        }
        if (!"ab".equals(Format.rpad("abc", 2, "x"))) {
            System.out.println("rpad has an error (4)");
        }
        if (!"xxabc".equals(Format.lpad("abc", 5, "x"))) {
            System.out.println("lpad has an error (1) " + Format.lpad("abc", 5, "x"));
        }
        if (!"xxabc".equals(Format.lpad("abc", 5, "xx"))) {
            System.out.println("lpad has an error (2) " + Format.lpad("abc", 5, "xx"));
        }
        if (!"xxabc".equals(Format.lpad("abc", 5, "xxx"))) {
            System.out.println("lpad has an error (3) " + Format.lpad("abc", 5, "xxx"));
        }
        if (!"bc".equals(Format.lpad("abc", 2, "x"))) {
            System.out.println("lpad has an error (4) " + Format.lpad("abc", 2, "x"));
        }
        if (!"xabc".equals(Format.center("abc", 5, "x"))) {
            System.out.println("center has an error (1) " + Format.center("abc", 5, "x"));
        }
        if (!"xabc".equals(Format.center("abc", 6, "xx"))) {
            System.out.println("center has an error (2) " + Format.center("abc", 6, "xx"));
        }
        if (!"xxabc".equals(Format.center("abc", 7, "x"))) {
            System.out.println("center has an error (3) " + Format.center("abc", 7, "x"));
        }
        if (!"xxx".equals(Format.replace("xxx", "y", "z"))) {
            System.out.println("replace error (1) :" + Format.replace("xxx", "y", "z"));
        }
        if (!"zzz".equals(Format.replace("xxx", "x", "z"))) {
            System.out.println("replace error (2) :" + Format.replace("xxx", "x", "z"));
        }
        if (!"zx".equals(Format.replace("xyx", "xy", "z"))) {
            System.out.println("replace error (3) :" + Format.replace("xyx", "xy", "z"));
        }
        if (!"zz".equals(Format.replace("xyxy", "xy", "z"))) {
            System.out.println("replace error (4) :" + Format.replace("xyxy", "xy", "z"));
        }
        if (!"z234".equals(Format.replace("1234", "1", "z"))) {
            System.out.println("replace error (5) :" + Format.replace("1234", "1", "z"));
        }
        if (!"123z".equals(Format.replace("1234", "4", "z"))) {
            System.out.println("replace error (6) :" + Format.replace("1234", "4", "z"));
        }
    }
}

