/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.analysis.AnalysisAppletComponent;
import de.caff.asteroid.analysis.AnalysisAppletDisplay;
import de.caff.asteroid.analysis.AnalysisAppletFrame;
import de.caff.i18n.I18n;
import de.caff.i18n.swing.RJButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;

public class AnalysisApplet
extends JApplet {
    public static final String VERSION = "0.73";
    public static final String PARAM_FRAME = "framed";
    public static final String PARAM_FRAME_WIDTH = "framewidth";
    public static final String PARAM_FRAME_HEIGHT = "framewidth";
    public static final String PARAM_FRAME_BUTTON_TEXT = "frameButtonText";
    public static final String PARAM_FRAME_BUTTON_ICON = "frameButtonIcon";
    public static final String PARAM_FRAME_BUTTON_TOOLTIP = "frameButtonTooltip";
    public static final String PARAM_FILE = "file";
    public static final String PARAM_AUTO_START = "autoStart";
    private boolean framed;
    private AnalysisAppletDisplay appletDisplay;

    public AnalysisApplet() {
        this.getContentPane().setLayout(new BorderLayout());
    }

    public void init() {
        if (this.appletDisplay == null) {
            if (this.getBooleanParameter(PARAM_FRAME, false)) {
                this.framed = true;
                final AnalysisAppletFrame appletFrame = new AnalysisAppletFrame(this);
                Box outer = Box.createHorizontalBox();
                Box inner = Box.createVerticalBox();
                String buttonText = this.getParameter(PARAM_FRAME_BUTTON_TEXT);
                String buttonIconURL = this.getParameter(PARAM_FRAME_BUTTON_ICON);
                JButton button = null;
                if (buttonText != null || buttonIconURL != null) {
                    ImageIcon icon = null;
                    if (buttonIconURL != null) {
                        try {
                            icon = new ImageIcon(this.getAppletContext().getImage(new URL(this.getDocumentBase(), buttonIconURL)));
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                    button = new JButton(buttonText, icon);
                    String buttonTooltip = this.getParameter(PARAM_FRAME_BUTTON_TOOLTIP);
                    if (buttonTooltip != null) {
                        button.setToolTipText(buttonTooltip);
                    }
                }
                if (button == null) {
                    button = new RJButton("btnShowFrame");
                }
                outer.add(Box.createHorizontalGlue());
                outer.add(inner);
                outer.add(Box.createHorizontalGlue());
                inner.add(Box.createVerticalGlue());
                inner.add(button);
                inner.add(Box.createVerticalGlue());
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        appletFrame.setVisible(true);
                        appletFrame.toFront();
                    }
                });
                appletFrame.setSize(this.getIntParameter("framewidth", 640), this.getIntParameter("framewidth", 520));
                this.getContentPane().add((Component)outer, "Center");
                this.appletDisplay = appletFrame;
            } else {
                AnalysisAppletComponent appletComp = new AnalysisAppletComponent(this);
                this.getContentPane().add((Component)appletComp, "Center");
                this.appletDisplay = appletComp;
            }
            String file = this.getParameter(PARAM_FILE);
            if (file != null) {
                this.appletDisplay.showDumpFile(file, this.getBooleanParameter(PARAM_AUTO_START, false));
            }
        }
    }

    public void stop() {
        if (!this.framed) {
            this.appletDisplay.stopAnimation();
        }
    }

    private int getIntParameter(String name, int fallback) {
        int result = fallback;
        String param = this.getParameter(name);
        if (name != null) {
            try {
                result = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private boolean getBooleanParameter(String name, boolean fallback) {
        boolean result = fallback;
        String param = this.getParameter(name);
        if (name != null) {
            result = Boolean.parseBoolean(param);
        }
        return result;
    }

    public void showDumpFile(String dumpFile) {
        this.showDumpFile(dumpFile, false);
    }

    public void showDumpFile(String dumpFile, boolean autoStart) {
        this.appletDisplay.showDumpFile(dumpFile, autoStart);
    }

    public String getAppletInfo() {
        return String.format("Asteroids Dumpfile Analyser V. %s \nWritten by Rammi (rammi@caff.de) in 2008 \nUse freely without restrictions. \nSee http://caff.de/asteroid/ for more info and sources.", VERSION);
    }

    public String[][] getParameterInfo() {
        return new String[][]{{PARAM_FILE, "url", "location of dump file to display"}, {PARAM_AUTO_START, "boolean", "start running after file is loaded (only if file parameter is given)"}, {PARAM_FRAME, "boolean", "true: run in frame; false: run in page"}, {"framewidth", "int > 0", "start width of frame in frame mode"}, {"framewidth", "int > 0", "start height of frame in frame mode"}, {PARAM_FRAME_BUTTON_TEXT, "string", "inpage button text in frame mode"}, {PARAM_FRAME_BUTTON_ICON, "url", "inpage button icon in frame mode"}, {PARAM_FRAME_BUTTON_TOOLTIP, "string", "inpage button tooltip text in frame mode"}};
    }

    static {
        I18n.addAppResourceBase("de.caff.asteroid.analysis.resources.AnalysisApplet");
    }
}

