/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.Drawable;
import de.caff.asteroid.Explosion;
import de.caff.asteroid.GameData;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Text;
import de.caff.asteroid.Ufo;
import de.caff.util.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class AnniversaryAnimation
implements GameData,
Drawable {
    private static final Random random = new Random();
    private List<AnimatedObject> animatedObjects = new LinkedList<AnimatedObject>();

    AnniversaryAnimation(String text) {
        int centerX = 512;
        int centerY = 0;
        int startX = 0;
        int startY = 512;
        int offset = 2;
        int noise = 4;
        double len = Tools.getLength(centerX - startX, centerY - startY);
        double startAngle = Math.atan2(startY - centerY, startX - centerX);
        double endAngle = Math.PI - startAngle;
        double deltaAngle = (endAngle - startAngle) / (double)(text.length() + 4 - 1);
        for (int c = 0; c < text.length(); ++c) {
            this.animatedObjects.add(new AsteroidLetter(text.charAt(c), centerX + (int)(len * Math.cos(startAngle + (double)(c + 2) * deltaAngle)), centerY + (int)(len * Math.sin(startAngle + (double)(c + 2) * deltaAngle) + 4.0 * random.nextGaussian())));
        }
        this.animatedObjects.add(new AnimatedShip(512, 384, random.nextDouble() * 2.0 * Math.PI));
    }

    public void draw(Graphics2D g) {
        for (AnimatedObject obj : this.animatedObjects) {
            obj.draw(g);
        }
    }

    public void nextStep() {
        LinkedList<AnimatedObject> futureList = new LinkedList<AnimatedObject>();
        for (AnimatedObject obj : this.animatedObjects) {
            obj.nextStep(this.animatedObjects, futureList);
        }
        this.animatedObjects = futureList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnimatedBullet
    implements AnimatedObject {
        static final int BULLET_LIFE = 90;
        private Bullet bullet;
        private Point velocity;

        AnimatedBullet(int x, int y, int vx, int vy) {
            this.bullet = new Bullet(0, x, y);
            this.bullet.setLifetime(90);
            this.velocity = new Point(vx, vy);
        }

        @Override
        public void nextStep(Collection<AnimatedObject> currentObjects, List<AnimatedObject> collector) {
            Bullet old = this.bullet;
            Point next = new Point(old.getX() + this.velocity.x, old.getY() + this.velocity.y);
            if (next.x < 0) {
                next.x += 1024;
            } else if (next.x >= 1024) {
                next.x -= 1024;
            }
            if (next.y < 128) {
                next.y += 767;
            } else if (next.y >= 895) {
                next.y -= 767;
            }
            this.bullet = new Bullet(old.getIndex(), next.x, next.y);
            this.bullet.setLifetime(old.getLifetime() - 1);
            for (AnimatedObject obj : currentObjects) {
                if (!obj.isHit(this.bullet)) continue;
                this.bullet = null;
                break;
            }
            if (this.bullet != null && this.bullet.getLifetime() > 0) {
                collector.add(this);
            }
        }

        @Override
        public boolean isHit(Bullet bullet) {
            return false;
        }

        @Override
        public void draw(Graphics2D g) {
            if (this.bullet != null) {
                this.bullet.draw(g);
            }
        }

        @Override
        public boolean isTarget() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnimatedCongratulation
    implements AnimatedObject {
        private static final String CONGRATS_TEXT = "HERZLICHEN GLUECKWUNSCH";
        private static final int CONGRATS_SCALE = 1;
        private static final String ABOUT_TEXT = String.format("ANALYZER APPLET VERSI0N %s", "0.72".replaceAll("\\.", " D0T "));
        private static final int FOOTNOTE_BORDER = 10;
        private static final int ABOUT_SCALE = 0;
        private static final Point ABOUT_POS = new Point(10, 138);
        private static final String ORIGIN_TEXT = "2008 RAMMI AT CAFF D0T DE";
        private static final int ORIGIN_SCALE = 0;
        private static final Point ORIGIN_POS = new Point(1014 - Text.getTextBounds((String)"2008 RAMMI AT CAFF D0T DE", (double)Math.pow((double)2.0, (double)0.0)).width, 138);
        private static final int LANE_Y = 320;
        private static final int GAP = 8;
        private static final int SPEED = 2;
        private final int endX;
        private int x;
        private final int textWidth;
        private final int textOffsetY;

        AnimatedCongratulation() {
            Rectangle bounds = Text.getTextBounds(CONGRATS_TEXT, Math.pow(2.0, 1.0));
            this.textWidth = bounds.width;
            this.textOffsetY = -((int)bounds.getCenterY());
            this.endX = (1024 - this.textWidth - 16 - 8) / 2 - 8;
            this.x = 1224;
        }

        @Override
        public void nextStep(Collection<AnimatedObject> currentObjects, List<AnimatedObject> collector) {
            if (this.x > this.endX) {
                this.x -= 2;
            }
            collector.add(this);
        }

        @Override
        public boolean isHit(Bullet bullet) {
            return false;
        }

        @Override
        public boolean isTarget() {
            return false;
        }

        @Override
        public void draw(Graphics2D g) {
            Graphics2D g2 = (Graphics2D)g.create();
            Ufo bigUfo = new Ufo(this.x, 320, 15);
            Ufo smallUfo = new Ufo(this.x + this.textWidth + 16 + 8 + 16, 320, 14);
            bigUfo.draw(g2);
            smallUfo.draw(g2);
            new Text(CONGRATS_TEXT, this.x + 16 + 8, 320 + this.textOffsetY, 1).draw(g2);
            if (this.x <= this.endX) {
                new Text(ABOUT_TEXT, AnimatedCongratulation.ABOUT_POS.x, AnimatedCongratulation.ABOUT_POS.y, 0).draw(g2);
                new Text(ORIGIN_TEXT, AnimatedCongratulation.ORIGIN_POS.x, AnimatedCongratulation.ORIGIN_POS.y, 0).draw(g2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnimatedShip
    implements AnimatedObject {
        private static final int DIR_LENGTH = 10000;
        private double direction;
        private SpaceShip ship;
        private boolean firedInLastStep;
        private boolean finished;

        AnimatedShip(int x, int y, double direction) {
            this.direction = direction;
            Point v = this.getDirectionVector(10000);
            this.ship = new SpaceShip(x, y, v.x, v.y);
        }

        private Point getDirectionVector(int length) {
            return new Point((int)((double)length * Math.cos(this.direction)), (int)((double)length * Math.sin(this.direction)));
        }

        private static boolean haveTargets(Collection<AnimatedObject> objects) {
            for (AnimatedObject obj : objects) {
                if (!obj.isTarget()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void nextStep(Collection<AnimatedObject> currentObjects, List<AnimatedObject> collector) {
            if (!this.finished) {
                if (!this.firedInLastStep) {
                    if (random.nextDouble() < 0.1) {
                        Point d = this.getDirectionVector(2 * this.ship.getSize());
                        Point v = this.getDirectionVector(8);
                        AnimatedBullet bullet = new AnimatedBullet(this.ship.getX() + d.x, this.ship.getY() + d.y, v.x, v.y);
                        collector.add(0, bullet);
                        this.firedInLastStep = true;
                    }
                } else {
                    this.firedInLastStep = false;
                }
                if (!AnimatedShip.haveTargets(currentObjects)) {
                    this.finished = true;
                    collector.add(new AnimatedCongratulation());
                }
            }
            if (random.nextDouble() < 0.5) {
                this.direction += random.nextDouble() * Math.PI / 20.0 - 0.10471975511965977;
                Point v = this.getDirectionVector(10000);
                this.ship = new SpaceShip(this.ship.getX(), this.ship.getY(), v.x, v.y);
            }
            collector.add(this);
        }

        @Override
        public boolean isHit(Bullet bullet) {
            return false;
        }

        @Override
        public void draw(Graphics2D g) {
            this.ship.draw((Graphics2D)g.create());
        }

        @Override
        public boolean isTarget() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AsteroidLetter
    implements AnimatedObject {
        private static final int LETTER_SCALE = 2;
        private static final int EXPLOSION_REPEATS = 6;
        private static final Color[] EXPLOSION_COLORS = new Color[]{Color.white, Color.red, Color.yellow, Color.magenta, Color.orange, Color.blue, Color.cyan, Color.green, Color.pink};
        private final double deltaRot;
        private double rotation;
        private Asteroid asteroid;
        private Point position;
        private List<Explosion> explosions;
        private Text text;
        private Color textColor;

        AsteroidLetter(char ch, int x, int y) {
            this.position = new Point(x, y);
            this.asteroid = new Asteroid(0, 0, 0, 0, random.nextInt(4));
            this.rotation = random.nextDouble() * 2.0 * Math.PI;
            this.deltaRot = random.nextDouble() * Math.PI / 60.0 - 0.02617993877991494;
            String txt = Character.toString(ch);
            Rectangle txtBounds = Text.getTextBounds(txt, Math.pow(2.0, 2.0));
            int centerX = (int)txtBounds.getCenterX();
            int centerY = (int)txtBounds.getCenterY();
            this.text = new Text(txt, -centerX, -centerY, 2);
        }

        @Override
        public boolean isHit(Bullet bullet) {
            if (this.asteroid != null && Tools.getLength(bullet.getDelta(this.position)) < (double)this.asteroid.getSize()) {
                this.asteroid = null;
                this.explosions = new LinkedList<Explosion>();
                for (Explosion explosion : new Explosion[]{new Explosion(0, 0, 11, Explosion.Type.S), new Explosion(0, 0, 12, Explosion.Type.S), new Explosion(0, 0, 13, Explosion.Type.S), new Explosion(0, 0, 14, Explosion.Type.S), new Explosion(0, 0, 15, Explosion.Type.S), new Explosion(0, 0, 0, Explosion.Type.S), new Explosion(0, 0, 11, Explosion.Type.L), new Explosion(0, 0, 12, Explosion.Type.L), new Explosion(0, 0, 13, Explosion.Type.L), new Explosion(0, 0, 14, Explosion.Type.L), new Explosion(0, 0, 15, Explosion.Type.L), new Explosion(0, 0, 0, Explosion.Type.L), new Explosion(0, 0, 11, Explosion.Type.XL), new Explosion(0, 0, 12, Explosion.Type.XL), new Explosion(0, 0, 13, Explosion.Type.XL), new Explosion(0, 0, 14, Explosion.Type.XL), new Explosion(0, 0, 15, Explosion.Type.XL), new Explosion(0, 0, 0, Explosion.Type.XL), new Explosion(0, 0, 11, Explosion.Type.XXL), new Explosion(0, 0, 12, Explosion.Type.XXL), new Explosion(0, 0, 13, Explosion.Type.XXL), new Explosion(0, 0, 14, Explosion.Type.XXL), new Explosion(0, 0, 15, Explosion.Type.XXL), new Explosion(0, 0, 0, Explosion.Type.XXL)}) {
                    for (int r = 6; r > 0; --r) {
                        this.explosions.add(explosion);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public void nextStep(Collection<AnimatedObject> currentObjects, List<AnimatedObject> collector) {
            this.rotation += this.deltaRot;
            if (this.explosions != null) {
                this.explosions.remove(0);
                if (this.explosions.isEmpty()) {
                    this.explosions = null;
                    this.textColor = EXPLOSION_COLORS[random.nextInt(EXPLOSION_COLORS.length)];
                }
            }
            collector.add(this);
        }

        @Override
        public void draw(Graphics2D g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.translate(this.position.x, this.position.y);
            if (this.asteroid != null) {
                g2.rotate(this.rotation);
                this.asteroid.draw(g2);
            } else if (this.explosions != null) {
                this.text.draw(g2);
                g2.scale(2.0, 2.0);
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(EXPLOSION_COLORS[random.nextInt(EXPLOSION_COLORS.length)]);
                g2.draw(this.explosions.get(0).getExplosionShape());
            } else {
                g2.translate(this.text.getX(), this.text.getY());
                g2.setColor(this.textColor);
                Text.drawText(g2, this.text.getText(), Math.pow(2.0, 2.0));
            }
        }

        @Override
        public boolean isTarget() {
            return this.asteroid != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AnimatedObject
    extends Drawable {
        public void nextStep(Collection<AnimatedObject> var1, List<AnimatedObject> var2);

        public boolean isHit(Bullet var1);

        public boolean isTarget();
    }
}

