// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.analysis;

import de.caff.i18n.I18n;
import de.caff.i18n.swing.RJButton;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;

/**
 *  Applet to display dump files.
 */
public class AnalysisApplet
        extends JApplet
{
  static {
    I18n.addAppResourceBase("de.caff.asteroid.analysis.resources.AnalysisApplet");
  }
  public static final String VERSION = "0.73";

  public static final String PARAM_FRAME                = "framed";
  public static final String PARAM_FRAME_WIDTH          = "framewidth";
  public static final String PARAM_FRAME_HEIGHT         = "framewidth";
  public static final String PARAM_FRAME_BUTTON_TEXT    = "frameButtonText";
  public static final String PARAM_FRAME_BUTTON_ICON    = "frameButtonIcon";
  public static final String PARAM_FRAME_BUTTON_TOOLTIP = "frameButtonTooltip";
  public static final String PARAM_FILE                 = "file";
  public static final String PARAM_AUTO_START           = "autoStart";

  /** Displayed in frame mode? */
  private boolean framed;

  /** The applet component where everything is displayed. */
  private AnalysisAppletDisplay appletDisplay;

  /**
   * Constructor.
   */
  public AnalysisApplet()
  {
    getContentPane().setLayout(new BorderLayout());
  }

  /**
   * Called by the browser or applet viewer to inform
   * this applet that it has been loaded into the system. It is always
   * called before the first time that the <code>start</code> method is
   * called.
   * <p/>
   * A subclass of <code>Applet</code> should override this method if
   * it has initialization to perform. For example, an applet with
   * threads would use the <code>init</code> method to create the
   * threads and the <code>destroy</code> method to kill them.
   * <p/>
   * The implementation of this method provided by the
   * <code>Applet</code> class does nothing.
   *
   * @see java.applet.Applet#destroy()
   * @see java.applet.Applet#start()
   * @see java.applet.Applet#stop()
   */
  @Override
  public void init()
  {
    if (appletDisplay == null) {
      if (getBooleanParameter(PARAM_FRAME, false)) {
        framed = true;
        final AnalysisAppletFrame appletFrame = new AnalysisAppletFrame(this);
        Box outer = Box.createHorizontalBox();
        Box inner = Box.createVerticalBox();
        String buttonText = getParameter(PARAM_FRAME_BUTTON_TEXT);
        String buttonIconURL = getParameter(PARAM_FRAME_BUTTON_ICON);
        JButton button = null;
        if (buttonText != null  ||  buttonIconURL != null) {
          Icon icon = null;
          if (buttonIconURL != null) {
            try {
              icon = new ImageIcon(getAppletContext().getImage(new URL(getDocumentBase(), buttonIconURL)));
            } catch (MalformedURLException e) {
              e.printStackTrace();
            }
          }
          button = new JButton(buttonText, icon);
          String buttonTooltip = getParameter(PARAM_FRAME_BUTTON_TOOLTIP);
          if (buttonTooltip != null) {
            button.setToolTipText(buttonTooltip);
          }
        }
        if (button == null) {
          // fallback
          button = new RJButton("btnShowFrame");
        }
        outer.add(Box.createHorizontalGlue());
        outer.add(inner);
        outer.add(Box.createHorizontalGlue());
        inner.add(Box.createVerticalGlue());
        inner.add(button);
        inner.add(Box.createVerticalGlue());
        button.addActionListener(new ActionListener()
        {
          public void actionPerformed(ActionEvent e)
          {
            appletFrame.setVisible(true);
            appletFrame.toFront();
          }
        });
        appletFrame.setSize(getIntParameter(PARAM_FRAME_WIDTH, 640),
                            getIntParameter(PARAM_FRAME_HEIGHT, 520));
        getContentPane().add(outer, BorderLayout.CENTER);

        appletDisplay = appletFrame;
      }
      else {
        AnalysisAppletComponent appletComp = new AnalysisAppletComponent(this);
        getContentPane().add(appletComp, BorderLayout.CENTER);

        appletDisplay = appletComp;
      }

      String file = getParameter(PARAM_FILE);
      if (file != null) {
        appletDisplay.showDumpFile(file, getBooleanParameter(PARAM_AUTO_START, false));
      }
    }
  }

  /**
   * Called by the browser or applet viewer to inform
   * this applet that it should stop its execution. It is called when
   * the Web page that contains this applet has been replaced by
   * another page, and also just before the applet is to be destroyed.
   * <p/>
   * A subclass of <code>Applet</code> should override this method if
   * it has any operation that it wants to perform each time the Web
   * page containing it is no longer visible. For example, an applet
   * with animation might want to use the <code>start</code> method to
   * resume animation, and the <code>stop</code> method to suspend the
   * animation.
   * <p/>
   * The implementation of this method provided by the
   * <code>Applet</code> class does nothing.
   *
   * @see java.applet.Applet#destroy()
   * @see java.applet.Applet#init()
   */
  @Override
  public void stop()
  {
    if (!framed) {
      // no need to use performance if not visible
      appletDisplay.stopAnimation();
    }
  }

  /**
   *  Get an integer parameter value.
   *  @param name     parameter name
   *  @param fallback fallback value
   *  @return parameter or fallback value if parameter is not available or not an integer
   */
  private int getIntParameter(String name, int fallback)
  {
    int result = fallback;
    String param = getParameter(name);
    if (name != null) {
      try {
        result = Integer.parseInt(param);
      } catch (NumberFormatException e) {
        e.printStackTrace();
      }
    }
    return result;
  }

  /**
   *  Get a boolean parameter value.
   *  @param name     parameter name
   *  @param fallback fallback value
   *  @return parameter or fallback value if parameter is not available or not an integer
   */
  private boolean getBooleanParameter(String name, boolean fallback)
  {
    boolean result = fallback;
    String param = getParameter(name);
    if (name != null) {
      result = Boolean.parseBoolean(param);
    }
    return result;
  }

  /**
   *  Load a new dump file.
   *  Does not start automatically.
   *  Invoke this method from JavaScript as a workaround to bug #6669818.
   *  @param dumpFile dump file
   */
  public void showDumpFile(String dumpFile)
  {
    showDumpFile(dumpFile, false);
  }

  /**
   *  Load a new dump file.
   *  Invoke this method from JavaScript as a workaround to bug #6669818.
   *  @param dumpFile dump file
   *  @param autoStart start automatically after file is loaded?
   */
  public void showDumpFile(String dumpFile, boolean autoStart)
  {
    appletDisplay.showDumpFile(dumpFile, autoStart);
  }

  /**
   * Returns information about this applet. An applet should override
   * this method to return a <code>String</code> containing information
   * about the author, version, and copyright of the applet.
   * <p/>
   * The implementation of this method provided by the
   * <code>Applet</code> class returns <code>null</code>.
   *
   * @return a string containing information about the author, version, and
   *         copyright of the applet.
   */
  @Override
  public String getAppletInfo()
  {
    return String.format("Asteroids Dumpfile Analyser V. %s \n" +
                         "Written by Rammi (rammi@caff.de) in 2008 \n" +
                         "Use freely without restrictions. \n" +
                         "See http://caff.de/asteroid/ for more info and sources.", VERSION);
  }

  /**
   * Returns information about the parameters that are understood by
   * this applet. An applet should override this method to return an
   * array of <code>Strings</code> describing these parameters.
   * <p/>
   * Each element of the array should be a set of three
   * <code>Strings</code> containing the name, the type, and a
   * description. For example:
   * <p><blockquote><pre>
   * String pinfo[][] = {
   * 	 {"fps",    "1-10",    "frames per second"},
   * 	 {"repeat", "boolean", "repeat image loop"},
   * 	 {"imgs",   "url",     "images directory"}
   * };
   * </pre></blockquote>
   * <p/>
   * The implementation of this method provided by the
   * <code>Applet</code> class returns <code>null</code>.
   *
   * @return an array describing the parameters this applet looks for.
   */
  @Override
  public String[][] getParameterInfo()
  {
    return new String[][] {
            { PARAM_FILE,                 "url",     "location of dump file to display" },
            { PARAM_AUTO_START,           "boolean", "start running after file is loaded (only if "+PARAM_FILE+" parameter is given)" },
            { PARAM_FRAME,                "boolean", "true: run in frame; false: run in page" },
            { PARAM_FRAME_WIDTH,          "int > 0", "start width of frame in frame mode" },
            { PARAM_FRAME_HEIGHT,         "int > 0", "start height of frame in frame mode" },
            { PARAM_FRAME_BUTTON_TEXT,    "string",  "inpage button text in frame mode" },
            { PARAM_FRAME_BUTTON_ICON,    "url",     "inpage button icon in frame mode" },
            { PARAM_FRAME_BUTTON_TOOLTIP, "string",  "inpage button tooltip text in frame mode" },
    };
  }
}
