/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameObject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Map;

public class ShipExplosion
extends GameObject {
    private static final Map<LineData, ShapeNode> SHAPE_NODES = new HashMap<LineData, ShapeNode>();
    private ShapeNode shapeNode;

    public ShipExplosion(int x, int y) {
        super(x, y);
    }

    public void addLine(int px, int py, int dx, int dy) {
        LineData ld = new LineData(px, py, px + dx, py + dy);
        if (this.shapeNode == null) {
            this.shapeNode = SHAPE_NODES.get(ld);
            if (this.shapeNode == null) {
                this.shapeNode = new ShapeNode(ld);
                SHAPE_NODES.put(ld, this.shapeNode);
            }
        } else {
            this.shapeNode = this.shapeNode.getShapeNode(ld);
        }
    }

    public Rectangle getBounds() {
        return this.shapeNode.getShape().getBounds();
    }

    public String getObjectType() {
        return "ShipExplosion";
    }

    public void draw(Graphics2D g) {
        g.setColor(Color.gray);
        g.draw(AffineTransform.getTranslateInstance(this.x, this.y).createTransformedShape(this.shapeNode.getShape()));
    }

    private static class ShapeNode {
        private final LineData line;
        private ShapeNode parent;
        private Shape shape;
        private Map<LineData, ShapeNode> subNodes;

        ShapeNode(LineData ld) {
            this.line = ld;
        }

        ShapeNode getShapeNode(LineData ld) {
            ShapeNode sub;
            if (this.subNodes == null) {
                this.subNodes = new HashMap<LineData, ShapeNode>();
            }
            if ((sub = this.subNodes.get(ld)) == null) {
                sub = new ShapeNode(ld);
                sub.parent = this;
                this.subNodes.put(ld, sub);
            }
            return sub;
        }

        private static GeneralPath createShape(ShapeNode node) {
            if (node == null) {
                return new GeneralPath();
            }
            GeneralPath path = ShapeNode.createShape(node.parent);
            node.line.addTo(path);
            return path;
        }

        Shape getShape() {
            if (this.shape == null) {
                this.shape = ShapeNode.createShape(this);
            }
            return this.shape;
        }
    }

    private static class LineData {
        private final int p1x;
        private final int p1y;
        private final int p2x;
        private final int p2y;

        LineData(int p1x, int p1y, int p2x, int p2y) {
            this.p1x = p1x;
            this.p1y = p1y;
            this.p2x = p2x;
            this.p2y = p2y;
        }

        void addTo(GeneralPath path) {
            path.moveTo(this.p1x, this.p1y);
            path.lineTo(this.p2x, this.p2y);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineData lineData = (LineData)o;
            if (this.p1x != lineData.p1x) {
                return false;
            }
            if (this.p1y != lineData.p1y) {
                return false;
            }
            if (this.p2x != lineData.p2x) {
                return false;
            }
            return this.p2y == lineData.p2y;
        }

        public int hashCode() {
            int result = this.p1x;
            result = 31 * result + this.p1y;
            result = 31 * result + this.p2x;
            result = 31 * result + this.p2y;
            return result;
        }
    }
}

