/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Glyph;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ufo
extends MovingGameObject {
    public static final int BIG_SIZE = 16;
    public static final int SMALL_SIZE = 8;
    private static final Color UFO_COLOR = new Color(192, 192, 192);
    public static final Glyph UFO_GLYPH = new Glyph(new byte[]{16, -8, 0, -16, -8, 12, -40, 8, 0, 40, 8, 13, 16, 24, 13, -16, 24, 12, -40, 8, 13, -16, -8, 13, -8, -24, 12, 8, -24, 12, 16, -8, 12, 40, 8, 13});
    private static final Shape BIG = AffineTransform.getScaleInstance(0.5, 0.5).createTransformedShape(UFO_GLYPH.getPath());
    private static final Shape SMALL = AffineTransform.getScaleInstance(0.5, 0.5).createTransformedShape(BIG);
    private final boolean big;

    public Ufo(int x, int y, int size) {
        super(x, y);
        this.big = size == 15;
    }

    @Override
    public int getSize() {
        return this.big ? 16 : 8;
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(UFO_COLOR);
        g.draw(AffineTransform.getTranslateInstance(this.x, this.y).createTransformedShape(this.big ? BIG : SMALL));
        this.drawVelocityVector(g, Color.red);
    }

    public String toString() {
        return String.format("Ufo@(%d,%d)*%d", this.x, this.y, this.getSize());
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<String>("Ufo Size", this.big ? "BIG" : "small"));
        return props;
    }

    @Override
    public String getObjectType() {
        return "Ufo";
    }

    @Override
    public int getScore() {
        return this.big ? 200 : 1000;
    }
}

