/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.Drawable;
import de.caff.asteroid.FrameDisplay;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.GameData;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.Text;
import de.caff.asteroid.analysis.AnniversaryAnimation;
import de.caff.asteroid.analysis.DumpFileChangeListener;
import de.caff.asteroid.analysis.FrameKeyInfoDisplay;
import de.caff.asteroid.analysis.SelectionAreaListener;
import de.caff.asteroid.analysis.TimeLine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Collection;

public class EnhancedFrameDisplay
extends FrameDisplay
implements SelectionAreaListener,
DumpFileChangeListener {
    private static final int MESSAGE_SIZE = 4;
    private static final Color SELECTION_COLOR = Color.magenta;
    private Rectangle[] selections = new Rectangle[0];
    private TimeLine timeLine;
    private Animation animation;
    private boolean hadDumpFile;
    private String message;

    public EnhancedFrameDisplay(TimeLine timeLine) {
        this(0, timeLine, null);
    }

    public EnhancedFrameDisplay(TimeLine timeLine, FrameKeyInfoDisplay fid) {
        this(0, timeLine, fid);
    }

    public EnhancedFrameDisplay(int width, TimeLine timeLine, final FrameKeyInfoDisplay fid) {
        super(width);
        this.timeLine = timeLine;
        if (fid != null) {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        Collection<GameObject> gameObjects = EnhancedFrameDisplay.this.pickAt(e.getPoint(), 2);
                        fid.setSelectedUserObjects(gameObjects.toArray(new GameObject[gameObjects.size()]));
                    }
                }
            });
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.message != null) {
            Graphics2D g2 = this.createAsteroidSpaceGraphics(g);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(new BasicStroke(3.0f, 1, 1));
            g2.setColor(SELECTION_COLOR);
            String[] lines = this.message.split("\n");
            int lineHeight = 60;
            int upperLineOffset = (lines.length - 1) * (lineHeight / 2);
            for (int l = 0; l < lines.length; ++l) {
                String line = lines[l];
                Rectangle r = Text.getTextBounds(line, 4.0);
                Graphics2D localG = (Graphics2D)g2.create();
                localG.translate((1024 - r.width) / 2 - r.x, (768 - r.height) / 2 - r.y + 128 + upperLineOffset - l * lineHeight / 2);
                Text.drawText(localG, line, 4.0);
            }
        } else {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(SELECTION_COLOR);
            AffineTransform trafo = this.getTrafo();
            for (Rectangle rect : this.selections) {
                GeneralPath p = new GeneralPath();
                p.moveTo((float)rect.getMinX(), (float)rect.getMinY());
                p.lineTo((float)rect.getMaxX(), (float)rect.getMinY());
                p.lineTo((float)rect.getMaxX(), (float)rect.getMaxY());
                p.lineTo((float)rect.getMinX(), (float)rect.getMaxY());
                p.closePath();
                p.transform(trafo);
                g2.draw(p);
            }
            if (this.timeLine.getDumpFile() == null) {
                if (!this.hadDumpFile) {
                    if (this.animation == null) {
                        this.animation = new Animation();
                        new Thread((Runnable)this.animation, "Anniversary Animation").start();
                    }
                    this.animation.draw(this.createAsteroidSpaceGraphics(g));
                }
            } else {
                if (this.animation != null) {
                    this.animation.stop();
                    this.animation = null;
                }
                this.hadDumpFile = true;
            }
        }
    }

    public void selectionAreasChanged(Rectangle[] areas) {
        this.selections = areas;
        this.repaint();
    }

    public void dumpFileChange() {
        this.repaint();
    }

    protected int getSessionTime(FrameInfo frame) {
        return this.timeLine.getSessionTime(frame.getIndex());
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message != null ? FrameInfo.canonize(message).trim() : null;
        this.repaint();
    }

    public void clearMessage() {
        this.setMessage(null);
    }

    private class Animation
    implements Runnable,
    Drawable,
    GameData {
        private AnniversaryAnimation anim = new AnniversaryAnimation("25 JAHRE C'T");
        private boolean running;

        private Animation() {
        }

        public synchronized boolean isRunning() {
            return this.running;
        }

        public synchronized void stop() {
            this.running = false;
        }

        public void run() {
            this.running = true;
            while (this.isRunning()) {
                if (EnhancedFrameDisplay.this.message == null) {
                    this.anim.nextStep();
                    EnhancedFrameDisplay.this.repaint();
                }
                try {
                    Thread.sleep(16L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void draw(Graphics2D g) {
            this.anim.draw(g);
        }
    }
}

