/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.EnumValue;
import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingEnumPreferenceProperty;
import java.awt.Component;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;

public class EnumEditor
extends AbstractBasicEditorProvider {
    private final SwingEnumPreferenceProperty property;
    private JComboBox comboBox;

    public EnumEditor(SwingEnumPreferenceProperty property, final Locale l) {
        super(property, l);
        this.property = property;
        EnumValue[] enumValues = property.getEnumValues(l);
        DefaultComboBoxModel<EnumValueLocalizer> model = new DefaultComboBoxModel<EnumValueLocalizer>();
        EnumValue value = property.getValue();
        int selected = 0;
        for (int e = 0; e < enumValues.length; ++e) {
            if (enumValues[e] == value) {
                selected = e;
            }
            model.addElement(new EnumValueLocalizer(enumValues[e], l));
        }
        this.comboBox = new JComboBox(model);
        this.comboBox.setSelectedIndex(selected);
        this.comboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JComponent comp = (JComponent)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                comp.setToolTipText(((EnumValue)value).getLongName(l));
                return comp;
            }
        });
    }

    public JComponent getEditor() {
        return this.comboBox;
    }

    public void reset() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboBox.getModel();
        this.comboBox = new JComboBox(model);
        EnumValue value = this.property.getValue();
        for (int e = model.getSize() - 1; e >= 0; --e) {
            if (((EnumValueLocalizer)model.getElementAt(e)).getBasicValue() != value) continue;
            this.comboBox.setSelectedIndex(e);
        }
    }

    public void save() {
        EnumValueLocalizer value = (EnumValueLocalizer)this.comboBox.getSelectedItem();
        this.property.setValue(value.getBasicValue());
    }

    public void goodBye() {
    }

    private static class EnumValueLocalizer
    implements EnumValue {
        private final EnumValue wrapped;
        private final Locale locale;

        public EnumValueLocalizer(EnumValue wrapped, Locale locale) {
            this.wrapped = wrapped;
            this.locale = locale;
        }

        public String getShortName(Locale l) {
            return this.wrapped.getShortName(l);
        }

        public String getLongName(Locale l) {
            return this.wrapped.getLongName(l);
        }

        public void storeTo(Preferences preferences, String key) {
            this.wrapped.storeTo(preferences, key);
        }

        public boolean isEqualTo(Preferences preferences, String key) {
            return this.wrapped.isEqualTo(preferences, key);
        }

        public Object getRealValue() {
            return this.wrapped.getRealValue();
        }

        public EnumValue getBasicValue() {
            return this.wrapped;
        }

        public String toString() {
            return this.wrapped.getShortName(this.locale);
        }
    }
}

