/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.swing.AbstractBasicGroupEditor;
import de.caff.util.settings.swing.EditablePreferenceGroup;
import de.caff.util.settings.swing.EditablePreferenceProperty;
import de.caff.util.settings.swing.EditorProvider;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TabbedGroupEditor
extends AbstractBasicGroupEditor {
    private JTabbedPane tabbedPane = new JTabbedPane(1, 1);

    public TabbedGroupEditor(final EditablePreferenceGroup property, Locale l) {
        super(property.getNameTag(), l);
        Iterator iterator = property.propertyIterator();
        while (iterator.hasNext()) {
            EditablePreferenceProperty epp = (EditablePreferenceProperty)iterator.next();
            EditorProvider provider = epp.getEditorProvider(l);
            this.addEditorProvider(provider);
            this.tabbedPane.addTab(provider.getTitleText(), new JScrollPane(provider.getEditor()));
            this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, provider.getToolTipText());
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                property.setTabIndex(TabbedGroupEditor.this.tabbedPane.getSelectedIndex());
            }
        });
        this.tabbedPane.setSelectedIndex(property.getTabIndex());
    }

    public JComponent getEditor() {
        return this.tabbedPane;
    }
}

