/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.gimmicks.swing.ResourcedAction;
import de.caff.i18n.I18n;
import de.caff.i18n.swing.RJButton;
import de.caff.i18n.swing.RJLabel;
import de.caff.i18n.swing.RJPanel;
import de.caff.util.debug.Debug;
import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingUrlListPreferenceProperty;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class UrlListEditor
extends AbstractBasicEditorProvider {
    private final SwingUrlListPreferenceProperty property;
    private JPanel panel;
    private JList list;
    private Action add = new ResourcedAction("tbAdd"){

        public void actionPerformed(ActionEvent e) {
            Component root = SwingUtilities.getRoot(UrlListEditor.this.panel);
            UrlDialog dialog = root instanceof Dialog ? new UrlDialog((Dialog)root, null) : (root instanceof Frame ? new UrlDialog((Frame)root, null) : new UrlDialog(null));
            dialog.show();
            String url = dialog.getUrl();
            if (url != null) {
                UrlListEditor.this.getModel().addElement(url);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    };
    private Action delete = new ResourcedAction("tbDelete"){

        public void actionPerformed(ActionEvent e) {
            UrlListEditor.this.getModel().removeElementAt(UrlListEditor.this.list.getSelectedIndex());
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    };
    private Action change = new ResourcedAction("tbChange"){

        public void actionPerformed(ActionEvent e) {
            Component root = SwingUtilities.getRoot(UrlListEditor.this.panel);
            UrlDialog dialog = root instanceof Dialog ? new UrlDialog((Dialog)root, UrlListEditor.this.list.getSelectedValue().toString()) : (root instanceof Frame ? new UrlDialog((Frame)root, UrlListEditor.this.list.getSelectedValue().toString()) : new UrlDialog(UrlListEditor.this.list.getSelectedValue().toString()));
            dialog.show();
            String url = dialog.getUrl();
            if (url != null) {
                UrlListEditor.this.getModel().setElementAt(url, UrlListEditor.this.list.getSelectedIndex());
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    };
    private Action up = new ResourcedAction("tbUp"){

        public void actionPerformed(ActionEvent e) {
            int index = UrlListEditor.this.list.getSelectedIndex();
            UrlListEditor.this.swap(index, index - 1);
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    };
    private Action down = new ResourcedAction("tbDown"){

        public void actionPerformed(ActionEvent e) {
            int index = UrlListEditor.this.list.getSelectedIndex();
            UrlListEditor.this.swap(index, index + 11);
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    };

    private DefaultListModel getModel() {
        return (DefaultListModel)this.list.getModel();
    }

    public UrlListEditor(SwingUrlListPreferenceProperty property, Locale l) {
        super(property, l);
        this.property = property;
        this.panel = new JPanel(new BorderLayout());
        JToolBar buttons = new JToolBar(1);
        buttons.setFloatable(false);
        buttons.add(this.add);
        buttons.add(this.delete);
        buttons.addSeparator();
        buttons.add(this.change);
        buttons.addSeparator();
        buttons.add(this.up);
        buttons.add(this.down);
        this.panel.add((Component)buttons, "East");
        this.list = new JList(UrlListEditor.createListModel(property.getUrlList()));
        this.panel.add((Component)new JScrollPane(this.list), "Center");
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                UrlListEditor.this.enableButtons(e.getFirstIndex());
            }
        });
        this.enableButtons(this.list.getSelectedIndex());
    }

    private static DefaultListModel createListModel(Collection c) {
        DefaultListModel model = new DefaultListModel();
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            model.addElement(iterator.next());
        }
        return model;
    }

    private void swap(int index1, int index2) {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        Object obj1 = model.getElementAt(index1);
        Object obj2 = model.getElementAt(index2);
        model.setElementAt(obj1, index2);
        model.setElementAt(obj2, index1);
    }

    private void enableButtons(int index) {
        if (index < 0) {
            this.delete.setEnabled(false);
            this.change.setEnabled(false);
            this.up.setEnabled(false);
            this.down.setEnabled(false);
        } else {
            this.delete.setEnabled(true);
            this.change.setEnabled(true);
            this.up.setEnabled(index > 0);
            this.down.setEnabled(index < this.list.getModel().getSize() - 1);
        }
    }

    public JComponent getEditor() {
        return this.panel;
    }

    public void reset() {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        model.removeAllElements();
        Iterator iterator = this.property.getUrlList().iterator();
        while (iterator.hasNext()) {
            model.addElement(iterator.next());
        }
    }

    public void save() {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        this.property.setUrlList(Arrays.asList(model.toArray()));
    }

    public void goodBye() {
    }

    private static class UrlDialog
    extends JDialog {
        private JTextField urlField;
        private JButton ok;
        private String result;

        UrlDialog(Dialog owner, String url) {
            super(owner);
            this.init(url);
            this.setLocationRelativeTo(owner);
        }

        UrlDialog(Frame owner, String url) {
            super(owner);
            this.init(url);
            this.setLocationRelativeTo(owner);
        }

        UrlDialog(String url) {
            this.init(url);
        }

        private void init(String url) {
            this.setModal(true);
            this.setDefaultCloseOperation(2);
            this.setTitle(I18n.getString("tiFontUrl"));
            this.urlField = new JTextField(url == null ? "" : url, 80);
            RJButton urlButton = new RJButton("btFontUrl");
            RJPanel panel = new RJPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createEtchedBorder()));
            this.ok = new RJButton("Ok");
            RJButton cancel = new RJButton("Cancel");
            Box buttons = Box.createHorizontalBox();
            this.getContentPane().setLayout(new BorderLayout());
            panel.add((Component)new RJLabel("lbFontUrl"), "West");
            panel.add((Component)this.urlField, "Center");
            panel.add((Component)urlButton, "East");
            buttons.add(Box.createHorizontalGlue());
            buttons.add(this.ok);
            buttons.add(cancel);
            buttons.add(Box.createHorizontalGlue());
            this.getContentPane().add((Component)panel, "North");
            this.getContentPane().add((Component)buttons, "South");
            urlButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File file;
                    JFileChooser chooser = new JFileChooser(UrlDialog.this.urlField.getText());
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setFileSelectionMode(1);
                    int returnVal = chooser.showOpenDialog(UrlDialog.this);
                    if (returnVal == 0 && (file = chooser.getSelectedFile()) != null) {
                        try {
                            UrlDialog.this.urlField.setText(file.toURL().toString());
                        }
                        catch (MalformedURLException x) {
                            Debug.error(x);
                        }
                    }
                }
            });
            this.urlField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    UrlDialog.this.checkUrl();
                }
            });
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UrlDialog.this.result = UrlDialog.this.urlField.getText().trim();
                    UrlDialog.this.dispose();
                }
            });
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UrlDialog.this.dispose();
                }
            });
            this.checkUrl();
            this.pack();
        }

        private void checkUrl() {
            String url = this.getUrl();
            try {
                new URL(url);
                this.ok.setEnabled(true);
                this.urlField.setBackground(Color.white);
            }
            catch (MalformedURLException x) {
                this.ok.setEnabled(false);
                this.urlField.setBackground(new Color(255, 192, 192));
            }
        }

        public String getUrl() {
            return this.result;
        }
    }
}

