// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.server;

import java.net.DatagramPacket;

/**
 *  Something which wants to know about incoming datagrams.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public interface DatagramListener
{
  /**
   *  Called when an incoming datagram was received.
   *
   *  This method is called in the communication thread.
   *  @param packet packet received
   *  @param sender datagram sender used for answers
   */
  public void datagramReceived(DatagramPacket packet, DatagramSender sender);

  /**
   *  Called when an outgoing datagram was sent.
   *
   *  This method is called in the communication thread.
   *  @param packet sent packet
   */
  public void datagramSent(DatagramPacket packet);
}