// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import java.util.*;

/**
 *  Base class for editors which handle a group of preference properties.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
abstract class AbstractBasicGroupEditor
        extends AbstractBasicEditorProvider
{
  /** The editor components. */
  private Collection editorProviders = new LinkedList();

  /**
   *  Constructor.
   *  @param baseTag basic i18n tag
   *  @param l       locale
   */
  public AbstractBasicGroupEditor(String baseTag, Locale l)
  {
    super(baseTag, l);
  }

  /**
   * Get a label text for this editor component.
   * If the text is null the editor component is inserted without a label.
   *
   * @return something to be displayed as a label
   */
  public String getLabelText()
  {
    return null;
  }

  /**
   * Get a title text for this editor component.
   *
   * @return a title text or <code>null</code> if a title makes no sense
   */
  public String getTitleText()
  {
    return super.getLabelText();
  }

  /**
   *  Is the value in the editor component valid?
   *  @return the answer
   */
  public boolean isValid()
  {
    for (Iterator iterator = editorProviders.iterator(); iterator.hasNext();) {
      EditorProvider provider = (EditorProvider)iterator.next();
      if (!provider.isValid()) {
        return false;
      }
    }
    return true;
  }

  /**
   * Reset the value in the editor to the basic value.
   */
  public void reset()
  {
    for (Iterator iterator = editorProviders.iterator(); iterator.hasNext();) {
      EditorProvider provider = (EditorProvider)iterator.next();
      provider.reset();
    }
  }

  /**
   * Set the basic value from the editor.
   */
  public void save()
  {
    for (Iterator iterator = editorProviders.iterator(); iterator.hasNext();) {
      EditorProvider provider = (EditorProvider)iterator.next();
      provider.save();
    }
  }

  /**
   * Called when the editor provider is no longer used.
   */
  public void goodBye()
  {
    for (Iterator iterator = editorProviders.iterator(); iterator.hasNext();) {
      EditorProvider provider = (EditorProvider)iterator.next();
      provider.goodBye();
    }
  }

  /**
   *  Add an editor provider.
   *  @param provider provider to add
   */
  protected void addEditorProvider(EditorProvider provider)
  {
    editorProviders.add(provider);
  }
}

