// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;

import java.util.ListResourceBundle;

/**
 *  Default i18n resources for the swing package.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public class SettingsResourceBundle_de
        extends ListResourceBundle
{
  /**
   *  Get the contents of this bundle.
   *  @return  the contents
   */
   public Object[][] getContents() {
    return contents;
  }


  private static final Object[][] contents = {
    // LOCALIZE THIS
    // General
    { "Ok"+I18n.SUFFIX_TEXT,            "Ok" },
    { "Cancel"+I18n.SUFFIX_TEXT,        "Abbruch" },

    { "Add"+I18n.SUFFIX_TEXT,           "Hinzufgen" },
    { "Delete"+I18n.SUFFIX_TEXT,        "Lschen" },
    { "Change"+I18n.SUFFIX_TEXT,        "ndern" },
    { "Up"+I18n.SUFFIX_TEXT,            "Nach oben" },
    { "Down"+I18n.SUFFIX_TEXT,          "Nach unten" },


    // Toolbars
    { "tbAdd"+I18n.SUFFIX_TEXT,           "Hinzufgen" },
    { "ttAdd"+I18n.SUFFIX_TOOLTIP,        "URL hinzufgen" },

    { "tbDelete"+I18n.SUFFIX_TEXT,        "Lschen" },
    { "ttDelete"+I18n.SUFFIX_TOOLTIP,     "Selektierte URL lschen" },

    { "tbChange"+I18n.SUFFIX_TEXT,        "ndern" },
    { "ttChange"+I18n.SUFFIX_TOOLTIP,     "Selektierte URL editieren" },

    { "tbUp"+I18n.SUFFIX_TEXT,            "Hoch" },
    { "ttUp"+I18n.SUFFIX_TOOLTIP,         "Selektierte URL einen Schritt hher schieben" },

    { "tbDown"+I18n.SUFFIX_TEXT,          "Runter" },
    { "ttDown"+I18n.SUFFIX_TOOLTIP,       "Selektierte URL einen Schritt tiefer schieben" },

    // title
    { "tiFontUrl",                        "Font-URL auswhlen" },   

    // labels
    { "lbFontUrl"+I18n.SUFFIX_TEXT,       "Font-URL:" },

    // buttons
    { "btChangeColor"+I18n.SUFFIX_TEXT,   "Farbe ndern..." },

    { "btFontUrl"+I18n.SUFFIX_TEXT,       "..." },
    { "btFontUrl"+I18n.SUFFIX_TOOLTIP,    "Lokales Verzeichnis auswhlen" },

    // formats
    { "valueNameFormat", "%0:" },
  };
}
