/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.SimpleVelocityPreparer;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import de.caff.util.Pair;
import de.caff.util.Tools;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprovedVelocityPreparer
extends SimpleVelocityPreparer {
    private static final double MIN_BULLET_DELTA = 18.0;
    private static final double MAX_BULLET_DELTA = 22.0;
    private static final Point2D NULL_POINT = new Point();
    private int asteroidIdCounter = 0;
    private int bulletIdCounter = 0;
    private AverageVelocity[][] averageAsteroidVelocities = new AverageVelocity[256][256];
    private AverageVelocity[][] averageBulletVelocities = new AverageVelocity[256][256];
    private AverageVelocity shipVelocity;

    @Override
    protected void prepareAsteroids(LinkedList<FrameInfo> frameInfos, FrameInfo prevFrame, FrameInfo currFrame) {
        SimpleVelocityPreparer.AsteroidSelector selector = new SimpleVelocityPreparer.AsteroidSelector(currFrame.getAsteroids());
        int oldPhase = prevFrame.getIndex() % 256;
        int newPhase = currFrame.getIndex() % 256;
        Arrays.fill(this.averageAsteroidVelocities[newPhase], null);
        for (Asteroid ast : prevFrame.getAsteroids()) {
            Asteroid candidate = selector.getBestMatch(ast);
            if (candidate == null) continue;
            AverageVelocity average = this.averageAsteroidVelocities[oldPhase][ast.getIndex()];
            if (average != null) {
                average.add(candidate.getX() - ast.getX(), candidate.getY() - ast.getY());
            } else {
                average = new AverageVelocity(candidate.getX() - ast.getX(), candidate.getY() - ast.getY());
            }
            candidate.setVelocity(average.getAverageX(), average.getAverageY());
            Point2D offset = average.getPositionCorrection();
            candidate.correctLocation(offset.getX(), offset.getY());
            candidate.inheret(ast);
            this.averageAsteroidVelocities[newPhase][candidate.getIndex()] = average;
        }
        for (Asteroid ast : currFrame.getAsteroids()) {
            if (ast.getIdentity() != null) continue;
            ast.setIdentity(this.asteroidIdCounter++);
        }
    }

    @Override
    protected void prepareBullets(LinkedList<FrameInfo> frameInfos, FrameInfo prevFrame, FrameInfo currFrame) {
        int oldPhase = prevFrame.getIndex() % 256;
        int newPhase = currFrame.getIndex() % 256;
        Arrays.fill(this.averageBulletVelocities[newPhase], null);
        TreeMap<BulletKey, Pair<Bullet>> result = new TreeMap<BulletKey, Pair<Bullet>>();
        for (Bullet oldBullet : prevFrame.getBullets()) {
            double futureX = (double)oldBullet.getX() + oldBullet.getVelocityX();
            double futureY = (double)oldBullet.getY() + oldBullet.getVelocityY();
            for (Bullet bullet : currFrame.getBullets()) {
                double dist2 = bullet.getSquaredDistance(futureX, futureY);
                if (!(dist2 < 256.0)) continue;
                result.put(new BulletKey(dist2, bullet.getIndex(), oldBullet.getIndex()), new Pair<Bullet>(oldBullet, bullet));
            }
        }
        LinkedList pairs = new LinkedList(result.values());
        while (!pairs.isEmpty()) {
            Pair pair = (Pair)pairs.remove(0);
            AverageVelocity average = this.averageBulletVelocities[oldPhase][((Bullet)pair.first).getIndex()];
            if (average != null) {
                average.add(((Bullet)pair.second).getX() - ((Bullet)pair.first).getX(), ((Bullet)pair.second).getY() - ((Bullet)pair.first).getY());
            } else {
                average = new AverageVelocity(((Bullet)pair.second).getX() - ((Bullet)pair.first).getX(), ((Bullet)pair.second).getY() - ((Bullet)pair.first).getY());
            }
            ((Bullet)pair.second).setVelocity(average.getAverageX(), average.getAverageY());
            Point2D offset = average.getPositionCorrection();
            ((Bullet)pair.second).correctLocation(offset.getX(), offset.getY());
            ((Bullet)pair.second).inheret((MovingGameObject)pair.first);
            this.averageBulletVelocities[newPhase][((Bullet)pair.second).getIndex()] = average;
            ListIterator it = pairs.listIterator();
            while (it.hasNext()) {
                Pair p = (Pair)it.next();
                if (!((Bullet)p.first).equals(pair.first) && !((Bullet)p.second).equals(pair.second)) continue;
                it.remove();
            }
        }
        for (Bullet bullet : currFrame.getBullets()) {
            if (bullet.getIdentity() != null) continue;
            bullet.setIdentity(this.bulletIdCounter++);
            SpaceShip ship = prevFrame.getSpaceShip();
            if (ship != null) {
                Point delta = bullet.getDelta(ship.getNextLocation());
                double deltaLen = Tools.getLength(delta);
                if (deltaLen >= 18.0 && deltaLen <= 22.0) {
                    Point2D bulletVelocity = prevFrame.getNextShootingDirection().getBulletVelocity();
                    bullet.setVelocity(bulletVelocity.getX() + ship.getVelocityX(), bulletVelocity.getY() + ship.getVelocityY());
                    AverageBulletVelocity average = new AverageBulletVelocity(bullet.getVelocity());
                    this.averageBulletVelocities[newPhase][bullet.getIndex()] = average;
                    bullet.setFriendly(true);
                    continue;
                }
                bullet.setFriendly(false);
                continue;
            }
            bullet.setFriendly(false);
        }
    }

    @Override
    protected void prepareSpaceShip(LinkedList<FrameInfo> frameInfos, FrameInfo prevFrame, FrameInfo currFrame) {
        SpaceShip prevShip = prevFrame.getSpaceShip();
        SpaceShip currShip = currFrame.getSpaceShip();
        if (prevShip != null && currShip != null) {
            if (this.shipVelocity == null) {
                this.shipVelocity = new AverageVelocity(prevShip.getDelta(currShip));
            } else {
                this.shipVelocity.add(prevShip.getDelta(currShip));
            }
            currShip.inheret(prevShip);
            currShip.setVelocity(this.shipVelocity.getAverageX(), this.shipVelocity.getAverageY());
        } else {
            this.shipVelocity = null;
        }
    }

    @Override
    protected void prepareUfo(LinkedList<FrameInfo> frameInfos, FrameInfo prevFrame, FrameInfo currFrame) {
        Ufo currUfo;
        super.prepareUfo(frameInfos, prevFrame, currFrame);
        Ufo prevUfo = prevFrame.getUfo();
        if (prevUfo != null && (currUfo = currFrame.getUfo()) != null) {
            currUfo.inheret(prevUfo);
        }
    }

    Point2D getAverageVelocity(FrameInfo frameInfo, Asteroid ast) {
        AverageVelocity velocity = this.averageAsteroidVelocities[frameInfo.getIndex() % 256][ast.getIndex()];
        return velocity != null ? velocity.getAverage() : NULL_POINT;
    }

    private static class AverageBulletVelocity
    extends AverageVelocity {
        private final double initVX;
        private final double initVY;

        AverageBulletVelocity(Point2D initV) {
            this(initV.getX(), initV.getY());
        }

        AverageBulletVelocity(double initVX, double initVY) {
            this.initVX = initVX;
            this.initVY = initVY;
        }

        public Point2D getAverage() {
            int size = this.lastVelocities.size();
            if (size < 8) {
                return new Point2D.Double(this.initVX, this.initVY);
            }
            return super.getAverage();
        }

        public double getAverageX() {
            int size = this.lastVelocities.size();
            if (size < 8) {
                if (size == 0) {
                    return this.initVX;
                }
                double vx = super.getAverageX();
                return (this.initVX * (double)(8 - size) + vx * (double)size) / 8.0;
            }
            return super.getAverageX();
        }

        public double getAverageY() {
            int size = this.lastVelocities.size();
            if (size < 8) {
                if (size == 0) {
                    return this.initVY;
                }
                double vy = super.getAverageY();
                return (this.initVY * (double)(8 - size) + vy * (double)size) / 8.0;
            }
            return super.getAverageY();
        }
    }

    private static class AverageVelocity {
        protected static final int MAX_COUNT = 8;
        private static final double CORRECTION = 0.125;
        protected List<Point> lastVelocities = new LinkedList<Point>();
        private int vx;
        private int vy;

        public AverageVelocity() {
        }

        public AverageVelocity(int vx, int vy) {
            this.vx = GameObject.normalizeDeltaX(vx);
            this.vy = GameObject.normalizeDeltaY(vy);
            this.lastVelocities.add(new Point(this.vx, this.vy));
        }

        public AverageVelocity(Point v) {
            this(v.x, v.y);
        }

        public void add(int velX, int velY) {
            Point v;
            if (this.lastVelocities.size() == 8) {
                v = this.lastVelocities.remove(0);
                this.vx -= v.x;
                this.vy -= v.y;
            }
            v = new Point(GameObject.normalizeDeltaX(velX), GameObject.normalizeDeltaY(velY));
            this.lastVelocities.add(v);
            this.vx += v.x;
            this.vy += v.y;
        }

        public void add(Point v) {
            this.add(v.x, v.y);
        }

        public Point2D getAverage() {
            if (this.lastVelocities.isEmpty()) {
                return new Point2D.Double(0.0, 0.0);
            }
            double count = 1.0 / (double)this.lastVelocities.size();
            return new Point2D.Double((double)this.vx * count, (double)this.vy * count);
        }

        public double getAverageX() {
            return this.lastVelocities.isEmpty() ? 0.0 : (double)this.vx / (double)this.lastVelocities.size();
        }

        public double getAverageY() {
            return this.lastVelocities.isEmpty() ? 0.0 : (double)this.vy / (double)this.lastVelocities.size();
        }

        public Point2D getPositionCorrection() {
            if (this.lastVelocities.size() < 8) {
                return NULL_POINT;
            }
            double cx = 0.0;
            double cy = 0.0;
            double ax = this.getAverageX();
            double ay = this.getAverageY();
            if (this.vx % 8 != 0 || this.vy % 8 != 0) {
                int px = 0;
                int py = 0;
                double fx = 0.0;
                double fy = 0.0;
                for (Point v : this.lastVelocities) {
                    py += v.y;
                    fy += ay;
                    if ((px += v.x) != (int)((fx += ax) + cx)) {
                        if ((int)(fx + cx) > px) {
                            while ((int)(fx + (cx -= 0.125)) > px) {
                            }
                        } else {
                            while ((int)(fx + (cx += 0.125)) < px) {
                            }
                        }
                    }
                    if (py == (int)(fy + cy)) continue;
                    if ((int)(fy + cy) > py) {
                        while ((int)(fy + (cy -= 0.125)) > py) {
                        }
                        continue;
                    }
                    while ((int)(fy + (cy += 0.125)) < py) {
                    }
                }
            }
            return new Point2D.Double(cx, cy);
        }

        public String toString() {
            return String.format("(%d/%d, %d/%d)", this.vx, this.lastVelocities.size(), this.vy, this.lastVelocities.size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BulletKey
    implements Comparable<BulletKey> {
        private final double dist2;
        private final int deltaIndex;
        private final int firstIndex;

        BulletKey(double dist2, int newIndex, int oldIndex) {
            this.dist2 = dist2;
            this.firstIndex = newIndex;
            this.deltaIndex = newIndex - oldIndex;
        }

        @Override
        public int compareTo(BulletKey o) {
            int comp = Double.compare(this.dist2, o.dist2);
            if (comp == 0 && (comp = this.deltaIndex - o.deltaIndex) == 0) {
                comp = this.firstIndex - o.firstIndex;
            }
            return comp;
        }
    }
}

