/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.analysis.AnalysisAppletComponent;
import de.caff.asteroid.analysis.AnalysisAppletDisplay;
import de.caff.asteroid.analysis.AnalysisAppletFrame;
import de.caff.i18n.I18n;
import de.caff.i18n.swing.RJButton;
import de.caff.util.Utility;
import de.caff.util.debug.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;

public class AnalysisApplet
extends JApplet {
    public static final String VERSION = "0.96";
    public static final String PARAM_FRAME = "framed";
    public static final String PARAM_FRAME_WIDTH = "framewidth";
    public static final String PARAM_FRAME_HEIGHT = "framewidth";
    public static final String PARAM_FRAME_BUTTON_TEXT = "frameButtonText";
    public static final String PARAM_FRAME_BUTTON_ICON = "frameButtonIcon";
    public static final String PARAM_FRAME_BUTTON_TOOLTIP = "frameButtonTooltip";
    public static final String PARAM_FRAME_BUTTON_BLACK = "frameButtonBlack";
    public static final String PARAM_FILE = "file";
    public static final String PARAM_AUTO_START = "autoStart";
    private boolean framed;
    private boolean autoStart;
    private AnalysisAppletDisplay appletDisplay;

    public AnalysisApplet() {
        this.getContentPane().setLayout(new BorderLayout());
    }

    public void init() {
        Utility.setApplet(this);
        Debug.initFromProperties(126L);
        Debug.message("init()\nappletDisplay=%1\nthis=%2\nthread=%3", (Object)this.appletDisplay, (Object)Integer.toHexString(this.hashCode()), (Object)Thread.currentThread());
        if (this.appletDisplay == null) {
            this.autoStart = Utility.getBooleanParameter(PARAM_AUTO_START, false);
            if (Utility.getBooleanParameter(PARAM_FRAME, false)) {
                this.framed = true;
                final AnalysisAppletFrame appletFrame = new AnalysisAppletFrame(this);
                Box outer = Box.createHorizontalBox();
                Box inner = Box.createVerticalBox();
                String buttonText = this.getParameter(PARAM_FRAME_BUTTON_TEXT);
                String buttonIconURL = this.getParameter(PARAM_FRAME_BUTTON_ICON);
                JButton button = null;
                if (buttonText != null || buttonIconURL != null) {
                    ImageIcon icon = null;
                    if (buttonIconURL != null) {
                        try {
                            icon = new ImageIcon(this.getAppletContext().getImage(new URL(this.getDocumentBase(), buttonIconURL)));
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                    button = new JButton(buttonText, icon);
                    String buttonTooltip = this.getParameter(PARAM_FRAME_BUTTON_TOOLTIP);
                    if (buttonTooltip != null) {
                        button.setToolTipText(buttonTooltip);
                    }
                }
                if (button == null) {
                    button = new RJButton("btnShowFrame");
                }
                outer.add(Box.createHorizontalGlue());
                outer.add(inner);
                outer.add(Box.createHorizontalGlue());
                inner.add(Box.createVerticalGlue());
                inner.add(button);
                inner.add(Box.createVerticalGlue());
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        appletFrame.setVisible(true);
                        appletFrame.toFront();
                    }
                });
                appletFrame.setSize(Utility.getIntParameter("framewidth", 640), Utility.getIntParameter("framewidth", 520));
                this.getContentPane().add((Component)outer, "Center");
                this.appletDisplay = appletFrame;
                if (Utility.getBooleanParameter(PARAM_FRAME_BUTTON_BLACK, false)) {
                    this.getContentPane().setBackground(Color.black);
                    button.setBackground(Color.black);
                }
            } else {
                AnalysisAppletComponent appletComp = new AnalysisAppletComponent(this);
                this.getContentPane().add((Component)appletComp, "Center");
                this.appletDisplay = appletComp;
            }
            String file = this.getParameter(PARAM_FILE);
            if (file != null) {
                this.showDumpFile(file);
            }
        }
    }

    public void destroy() {
        Debug.message("destroy()\nthis=%1", (Object)Integer.toHexString(this.hashCode()));
    }

    public void start() {
        Debug.message("start()");
    }

    public void stop() {
        Debug.message("stop()");
        if (!this.framed) {
            this.appletDisplay.stopAnimation();
        }
    }

    public void showDumpFile(String dumpFile) {
        Debug.message("showDumpFile(%1)", (Object)dumpFile);
        this.appletDisplay.showDumpFile(dumpFile, this.autoStart);
    }

    public void runDumpFile(String dumpFile) {
        this.appletDisplay.showDumpFile(dumpFile, true);
    }

    public void loadDumpFile(String dumpFile) {
        this.appletDisplay.showDumpFile(dumpFile, false);
    }

    public String getAppletInfo() {
        return String.format("Asteroids Dumpfile Analyser V. %s \nWritten by Rammi (rammi@caff.de) in 2008 \nUse freely without restrictions, but at your own risk. \nSee http://caff.de/asteroid/ for more info and sources.", VERSION);
    }

    public String[][] getParameterInfo() {
        return new String[][]{{PARAM_FILE, "url", "location of dump file to display"}, {PARAM_AUTO_START, "boolean", "start running after file is loaded"}, {PARAM_FRAME, "boolean", "true: run in frame; false: run in page"}, {"framewidth", "int > 0", "start width of frame in frame mode"}, {"framewidth", "int > 0", "start height of frame in frame mode"}, {PARAM_FRAME_BUTTON_TEXT, "string", "inpage button text in frame mode"}, {PARAM_FRAME_BUTTON_ICON, "url", "inpage button icon in frame mode"}, {PARAM_FRAME_BUTTON_TOOLTIP, "string", "inpage button tooltip text in frame mode"}, {PARAM_FRAME_BUTTON_BLACK, "boolean", "only for frame mode: paint the button black?"}, {"debug.show.window", "boolean", "show debug window?"}, {"debug.print.console", "boolean", "print debug messages to console?"}, {"debug.mask", "TSWEFLA", "T:Trace, S:Standard, W:Warning, E:Error, F:Fatal, L:Log, A:Assertions"}};
    }

    static {
        I18n.addAppResourceBase("de.caff.asteroid.analysis.resources.AnalysisApplet");
    }
}

