/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis.statistics;

import de.caff.asteroid.AbstractBasicGameObjectVisitor;
import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.Property;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import de.caff.asteroid.analysis.FrameKeyInfo;
import de.caff.asteroid.analysis.statistics.AbstractBasicDumpFileStatistics;
import de.caff.i18n.I18n;
import de.caff.util.Tools;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulletStatistics
extends AbstractBasicDumpFileStatistics {
    private BulletStats friendly = new BulletStats();
    private BulletStats unfriendly = new BulletStats();

    private BulletStats getStatsForBullet(Bullet bullet) {
        return bullet.isFriendly() == Boolean.TRUE ? this.friendly : this.unfriendly;
    }

    @Override
    public void analyse(Collection<FrameKeyInfo> infos) {
        FrameKeyInfo lastInfo = null;
        FrameKeyInfo secondToLastInfo = null;
        LinkedList<Bullet> missingBullets = new LinkedList<Bullet>();
        LinkedList<MovingGameObject> missingObjects = new LinkedList<MovingGameObject>();
        for (FrameKeyInfo info : infos) {
            missingBullets.clear();
            missingObjects.clear();
            if (lastInfo != null) {
                FrameInfo lastFrameInfo = lastInfo.getFrameInfo();
                for (Bullet bullet : lastFrameInfo.getBullets()) {
                    if (bullet.getReincarnation() != null) continue;
                    missingBullets.add(bullet);
                }
                if (!missingBullets.isEmpty()) {
                    if (lastInfo.getFrameInfo().getScore() != secondToLastInfo.getFrameInfo().getScore()) {
                        for (Asteroid ast : lastFrameInfo.getAsteroids()) {
                            if (ast.getReincarnation() != null) continue;
                            missingObjects.add(ast);
                        }
                        if (lastFrameInfo.getUfo() != null && info.getFrameInfo().getUfo() == null) {
                            missingObjects.add(lastFrameInfo.getUfo());
                        }
                        if (lastFrameInfo.getSpaceShip() != null && info.getFrameInfo().getSpaceShip() == null && lastFrameInfo.getNrShips() > info.getFrameInfo().getNrShips()) {
                            missingObjects.add(lastFrameInfo.getSpaceShip());
                        }
                        LinkedList<BulletObjectPair> possibleHits = new LinkedList<BulletObjectPair>();
                        for (Bullet bullet : missingBullets) {
                            for (MovingGameObject object : missingObjects) {
                                double dist = Tools.getSquaredLength(bullet.getCorrectedDelta(object));
                                if (!(dist < Tools.square(bullet.getSize() + object.getSize() + 1))) continue;
                                possibleHits.add(new BulletObjectPair(bullet, object, dist));
                            }
                        }
                        Collections.sort(possibleHits);
                        while (!possibleHits.isEmpty()) {
                            BulletObjectPair pair = (BulletObjectPair)possibleHits.get(0);
                            pair.getObject().visitedBy(this.getStatsForBullet(pair.getBullet()));
                            ListIterator it = possibleHits.listIterator();
                            while (it.hasNext()) {
                                BulletObjectPair bop = (BulletObjectPair)it.next();
                                if (pair.getBullet() != bop.getBullet() && pair.getObject() != bop.getObject()) continue;
                                it.remove();
                            }
                            missingBullets.remove(pair.getBullet());
                        }
                    }
                    if (!missingBullets.isEmpty()) {
                        System.out.println("Frame " + info.getFrameInfo().getIndex() + ": " + missingBullets.size() + " missing");
                        for (Bullet bullet : missingBullets) {
                            this.getStatsForBullet(bullet).addMissed();
                        }
                    }
                }
            }
            secondToLastInfo = lastInfo;
            lastInfo = info;
        }
    }

    @Override
    public String getTitle() {
        return I18n.getString("titleBulletStat");
    }

    @Override
    public boolean needPreparation() {
        return true;
    }

    @Override
    public Collection<Property> getProperties() {
        LinkedList<Property> props = new LinkedList<Property>();
        this.friendly.addToProperties(props, I18n.getString("propPrefixBulFriendly") + " ");
        this.unfriendly.addToProperties(props, I18n.getString("propPrefixBulUnfriendly") + " ");
        return props;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BulletObjectPair
    implements Comparable<BulletObjectPair> {
        private final Bullet bullet;
        private final MovingGameObject object;
        private final double distSquared;

        BulletObjectPair(Bullet bullet, MovingGameObject object, double distSquared) {
            this.bullet = bullet;
            this.object = object;
            this.distSquared = distSquared;
        }

        public Bullet getBullet() {
            return this.bullet;
        }

        public MovingGameObject getObject() {
            return this.object;
        }

        @Override
        public int compareTo(BulletObjectPair o) {
            return Double.compare(this.distSquared, o.distSquared);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BulletStats
    extends AbstractBasicGameObjectVisitor {
        private int missed;
        private int asteroidHits;
        private int ufoHits;
        private int shipHits;

        private BulletStats() {
        }

        @Override
        public void handle(Asteroid asteroid) {
            ++this.asteroidHits;
        }

        @Override
        public void handle(SpaceShip ship) {
            ++this.shipHits;
        }

        @Override
        public void handle(Ufo ufo) {
            ++this.ufoHits;
        }

        public void addMissed() {
            ++this.missed;
        }

        public int getMissed() {
            return this.missed;
        }

        public int getAsteroidHits() {
            return this.asteroidHits;
        }

        public int getShipHits() {
            return this.shipHits;
        }

        public int getUfoHits() {
            return this.ufoHits;
        }

        public int getHits() {
            return this.asteroidHits + this.shipHits + this.ufoHits;
        }

        public int getShots() {
            return this.getHits() + this.getMissed();
        }

        public void addToProperties(Collection<Property> props, String prefix) {
            props.add(new Property<Integer>(prefix + I18n.getString("propBulTotalShoots"), this.getShots()));
            props.add(new Property<Integer>(prefix + I18n.getString("propBulHits"), this.getHits()));
            props.add(new Property<Integer>(prefix + I18n.getString("propBulHitsAst"), this.getAsteroidHits()));
            props.add(new Property<Integer>(prefix + I18n.getString("propBulHitsUfo"), this.getUfoHits()));
            props.add(new Property<Integer>(prefix + I18n.getString("propBulHitsShip"), this.getShipHits()));
            props.add(new Property<Integer>(prefix + I18n.getString("propBulMissed"), this.getMissed()));
            props.add(new Property<String>(prefix + I18n.getString("propBulHitRatio"), AbstractBasicDumpFileStatistics.percentify(this.getHits(), this.getShots())));
        }
    }
}

