/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JComboBox;

public class RJComboBox
extends JComboBox
implements Localizable {
    protected boolean localeUnknown = true;
    protected String[] resTags = new String[0];

    public RJComboBox() {
        this.setEditable(false);
    }

    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener(this);
    }

    public void removeNotify() {
        I18n.removeLocalizationChangeListener(this);
        super.removeNotify();
    }

    public void add(String tag) {
        this.addItemTag(tag);
    }

    public void addItemTag(String tag) {
        super.addItem(I18n.getString(tag, this.getLocale()));
        String[] newTags = new String[this.resTags.length + 1];
        if (this.resTags.length > 0) {
            System.arraycopy(this.resTags, 0, newTags, 0, this.resTags.length);
        }
        newTags[this.resTags.length] = tag;
        this.resTags = newTags;
    }

    public String getTag(int index) {
        return this.resTags[index];
    }

    public String getSelectedTag() {
        return this.resTags[this.getSelectedIndex()];
    }

    public void insertItemAt(String tag, int index) {
        super.insertItemAt(I18n.getString(tag, this.getLocale()), index);
        String[] newTags = new String[this.resTags.length + 1];
        if (index > 0) {
            System.arraycopy(this.resTags, 0, newTags, 0, index);
        }
        newTags[index] = tag;
        if (index < this.resTags.length) {
            System.arraycopy(this.resTags, index, newTags, index + 1, this.resTags.length - index);
        }
        this.resTags = newTags;
    }

    public void remove(int index) {
        super.remove(index);
        String[] newTags = new String[this.resTags.length - 1];
        if (index > 0) {
            System.arraycopy(this.resTags, 0, newTags, 0, index);
        }
        if (index < this.resTags.length - 1) {
            System.arraycopy(this.resTags, index + 1, newTags, index, this.resTags.length - index - 1);
        }
        this.resTags = newTags;
    }

    public void remove(String tag) {
        for (int i = 0; i < this.resTags.length; ++i) {
            if (!this.resTags[i].equals(tag)) continue;
            this.remove(i);
            return;
        }
    }

    public void removeAll() {
        super.removeAll();
        this.resTags = new String[0];
    }

    public void setSelectedIndex(String tag) {
        for (int i = 0; i < this.resTags.length; ++i) {
            if (!this.resTags[i].equals(tag)) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    public void setLocale(Locale l) {
        Locale oldLocale = this.getLocale();
        super.setLocale(l);
        if (oldLocale != null && !oldLocale.equals(l)) {
            int selected = this.getSelectedIndex();
            for (int i = this.getItemCount() - 1; i >= 0; --i) {
                super.remove(i);
            }
            for (int t = 0; t < this.resTags.length; ++t) {
                super.addItem(I18n.getString(this.resTags[t], this.getLocale()));
            }
            this.setSelectedIndex(selected);
            this.invalidate();
        }
    }

    public Locale getLocale() {
        try {
            this.localeUnknown = false;
            return super.getLocale();
        }
        catch (IllegalComponentStateException x) {
            this.localeUnknown = true;
            return null;
        }
    }

    public void update(Graphics g) {
        if (this.localeUnknown) {
            this.setLocale(this.getLocale());
        } else {
            super.update(g);
        }
    }
}

