// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings;

import de.caff.i18n.I18n;

import java.util.Locale;
import java.util.MissingResourceException;

/**
 *  Helpful methods.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public class SettingsTools
{
  /**
   *  Get an optional I18n string.
   *  @param tag tag
   *  @param l   locale
   *  @return i18n string or <code>null</code>
   */
  public static String getOptionalI18nString(String tag, Locale l)
  {
    try {
      return I18n.getString(tag, l);
    } catch (MissingResourceException e) {
      return null;
    }
  }
}
