// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.util.settings.PreferenceProperty;

import java.util.Locale;

/**
 *  A preference property which is editable by means of a Swing component.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public interface EditablePreferenceProperty
        extends PreferenceProperty
{
  /**
   *  Get the editor provider which provides editor components for editing this preference property.
   *  @param  l  locale used for i18n
   *  @return editor provider
   */
  public EditorProvider getEditorProvider(Locale l);

  /**
   *  Get a name for the editor component.
   *  @param  l  locale used for i18n
   *  @return common title or <code>null</code> 
   */
  public String getName(Locale l);

}
