// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import javax.swing.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;

/**
 *  Editor provider for string properties.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
class StringEditor
        extends AbstractBasicEditorProvider
        implements PropertyChangeListener
{
  private final SwingStringPreferenceProperty property;
  private final JTextField textField;

  /**
   *  Constructor.
   *  @param property  string property for which this editor provider is created
   *  @param l         locale
   */
  public StringEditor(SwingStringPreferenceProperty property, Locale l)
  {
    super(property, l);
    this.property = property;
    textField = new JTextField(property.getValue(), 40);
    property.addValueChangeListener(this);
  }
  /**
   * Get an component for editing .
   *
   * @return editor component
   */
  public JComponent getEditor()
  {
    return textField;
  }

  /**
   * Reset the value in the editor to the basic value.
   */
  public void reset()
  {
    textField.setText(property.getValue());
  }

  /**
   * Set the basic value from the editor.
   */
  public void save()
  {
    property.setValue(textField.getText());
  }

  /**
   * This method gets called when a bound property is changed.
   *
   * @param evt A PropertyChangeEvent object describing the event source
   *            and the property that has changed.
   */
  public void propertyChange(PropertyChangeEvent evt)
  {
    if (!textField.getText().equals(evt.getNewValue().toString())) {
      textField.setText(evt.getNewValue().toString());
    }
  }

  /**
   * Called when the editor provider is no longer used.
   */
  public void goodBye()
  {
    property.removeValueChangeListener(this);
  }
}
