/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameObject;
import de.caff.asteroid.Property;
import de.caff.util.Tools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MovingGameObject
extends GameObject {
    public static final int NO_SCORE = 0;
    protected static final boolean WATCH_VELOCITIES = false;
    private static int minY = Integer.MAX_VALUE;
    private static int maxY = Integer.MIN_VALUE;
    private static final int ARROW_HEAD_SIZE = 8;
    private static final GeneralPath ARROW_HEAD = new GeneralPath();
    private double vx;
    private double vy;
    private int lifetime;
    private Integer identity;
    private MovingGameObject reincarnation;

    protected MovingGameObject(int x, int y) {
        super(x, y);
    }

    public Point getCenter() {
        return new Point(this.getX(), this.getY());
    }

    public abstract int getSize();

    @Override
    public void draw(Graphics2D g) {
        g.setColor(Color.white);
        int size = this.getSize();
        g.drawOval(this.getX() - size, this.getY() - size, 2 * size, 2 * size);
    }

    @Override
    public void drawEnhanced(Graphics2D g) {
        this.draw(g);
        this.drawVelocityVector(g, this.getVelocityDrawColor());
    }

    protected Color getVelocityDrawColor() {
        return Color.red;
    }

    public int getSquaredSize() {
        int size = this.getSize();
        return size * size;
    }

    public void setVelocity(double x, double y) {
        this.vx = x;
        this.vy = y;
    }

    public void setVelocity(Point2D v) {
        this.setVelocity(v.getX(), v.getY());
    }

    public void setVelocityFromDelta(MovingGameObject obj) {
        if (obj != null) {
            this.setVelocity(obj.getDelta(this));
        }
    }

    public double getVelocityX() {
        return this.vx;
    }

    public double getVelocityY() {
        return this.vy;
    }

    public Point2D getVelocity() {
        return new Point2D.Double(this.vx, this.vy);
    }

    public double getVelocityAngle() {
        return this.vx != 0.0 || this.vy != 0.0 ? Math.atan2(this.vy, this.vx) : -Math.PI;
    }

    public boolean hasKnownVelocity() {
        return this.vx != 0.0 || this.vy != 0.0;
    }

    protected void drawVelocityVector(Graphics2D g, Color color) {
        if (this.vx != 0.0 || this.vy != 0.0) {
            int scale = 16;
            g.setColor(color);
            g.drawLine(this.getX(), this.getY(), this.getX() + (int)((double)scale * this.vx), this.getY() + (int)((double)scale * this.vy));
            double angle = Math.atan2(this.vy, this.vx);
            AffineTransform at = AffineTransform.getTranslateInstance((double)this.getX() + (double)scale * this.vx, (double)this.getY() + (double)scale * this.vy);
            at.concatenate(AffineTransform.getRotateInstance(angle));
            g.fill(at.createTransformedShape(ARROW_HEAD));
        }
    }

    @Override
    public Rectangle getBounds() {
        Point center = this.getCenter();
        int size = this.getSize();
        return new Rectangle(center.x - size, center.y - size, 2 * size, 2 * size);
    }

    public Point getNextLocation() {
        return new Point((int)(this.getCorrectedX() + this.vx), (int)(this.getCorrectedY() + this.vy));
    }

    public Point2D getCorrectedNextLocation() {
        return new Point2D.Double(this.getCorrectedX() + this.vx, this.getCorrectedY() + this.vy);
    }

    public Point getPredictedLocation(int nrFrames) {
        return new Point((int)(this.getCorrectedX() + (double)nrFrames * this.vx), (int)(this.getCorrectedY() + (double)nrFrames * this.vy));
    }

    public Point2D getCorrectedPredictedLocation(double nrFrames) {
        return new Point2D.Double(this.getCorrectedX() + nrFrames * this.vx, this.getCorrectedY() + nrFrames * this.vy);
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Integer>("ID", this.getIdentity()));
        props.add(new Property<Integer>("Size", this.getSize()));
        props.add(new Property<Rectangle>("Bounds", this.getBounds()));
        props.add(new Property<Point2D>("Velocity", this.getVelocity()));
        return props;
    }

    public int getScore() {
        return 0;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public Integer getIdentity() {
        return this.identity;
    }

    public void setIdentity(Integer identity) {
        this.identity = identity;
    }

    public void inheret(MovingGameObject obj) {
        this.setIdentity(obj.getIdentity());
        obj.reincarnation = this;
        this.lifetime = obj.lifetime + 1;
    }

    public boolean _isHitting(MovingGameObject other, int frames) {
        Point2D delta = MovingGameObject.getTorusDelta(this.getCorrectedPredictedLocation(frames), other.getCorrectedPredictedLocation(frames));
        return delta.getX() * delta.getX() + delta.getY() * delta.getY() < Tools.square(this.getSize() + other.getSize());
    }

    public boolean isHitting(MovingGameObject other, int frames) {
        Point2D delta1 = MovingGameObject.getTorusDelta(this.getCorrectedPredictedLocation(frames), other.getCorrectedPredictedLocation(frames));
        double size = this.getSize() + other.getSize();
        double len1 = Tools.getLength(delta1);
        if (len1 < size) {
            return true;
        }
        Point2D delta = MovingGameObject.getTorusDelta(this.getCorrectedPredictedLocation(frames - 1), other.getCorrectedPredictedLocation(frames - 1));
        if (delta.getX() * delta1.getX() > 0.0 && delta.getY() * delta1.getY() > 0.0) {
            return false;
        }
        delta.setLocation(delta.getX() - delta1.getX(), delta.getY() - delta1.getY());
        double len = Tools.getLength(delta);
        return len != 0.0 && Math.abs(Tools.crossProduct(delta, delta1) / len) < size;
    }

    public MovingGameObject getReincarnation() {
        return this.reincarnation;
    }

    static {
        ARROW_HEAD.moveTo(0.0f, 0.0f);
        ARROW_HEAD.lineTo(-8.0f, 8.0f);
        ARROW_HEAD.lineTo(-8.0f, -8.0f);
        ARROW_HEAD.closePath();
    }
}

