// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.human;

import de.caff.i18n.I18n;
import de.caff.i18n.swing.RJLabel;
import de.caff.i18n.swing.RJButton;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

/**
 *  Ask for new game.
 */
class NewGameDialog
        extends JDialog
{
  static float FONT_SIZE = 24;
  static int   BORDER_WIDTH = 24;
  /**
   *  Constructor.
   *  @param client used for access to {@link de.caff.asteroid.human.HumanClient#exit(int)} and {@link HumanClient#restart()}
   */
  NewGameDialog(final HumanClient client)
  {
    super(client, true);

    setTitle(I18n.getString("diaNewGame"));

    JLabel label = new RJLabel("lbNewGame");
    label.setFont(label.getFont().deriveFont(FONT_SIZE));
    label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(),
                                                       BorderFactory.createEmptyBorder(BORDER_WIDTH, BORDER_WIDTH,
                                                                                       BORDER_WIDTH, BORDER_WIDTH)));
    getContentPane().add(label, BorderLayout.CENTER);
    JButton newGame = new RJButton("btNewGame");
    JButton endGame = new RJButton("btEndGame");
    Box bbox = Box.createHorizontalBox();
    bbox.add(Box.createHorizontalGlue());
    bbox.add(newGame);
    bbox.add(endGame);
    bbox.add(Box.createHorizontalGlue());
    bbox.setBorder(BorderFactory.createEmptyBorder(BORDER_WIDTH, BORDER_WIDTH,
                                                   BORDER_WIDTH, BORDER_WIDTH));
    getContentPane().add(bbox, BorderLayout.SOUTH);

    newGame.setDefaultCapable(true);

    setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
    pack();
    setLocationRelativeTo(client);

    newGame.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        client.restart();
      }
    });

    endGame.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        client.exit(0);
      }
    });

  }

}
