/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.AutoStarter;
import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameDisplay;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.FramePreparerSequence;
import de.caff.asteroid.PlayerStarter;
import de.caff.asteroid.ScoreFixer;
import de.caff.asteroid.SimpleVelocityPreparer;
import de.caff.asteroid.analysis.DatagramDumper;
import de.caff.asteroid.human.HumanClient;
import de.caff.asteroid.server.Bridge;
import java.io.IOException;
import javax.swing.JFrame;

public class AsteroidPlayerRunner {
    public static final String DEFAULT_PLAYER_STARTER_PACKAGE = AsteroidPlayerRunner.class.getPackage().getName() + ".";
    public static final String OPTIONAL_PLAYER_STARTER_EXTENSION = "PlayerStarter";
    public static final String[] DEFAULT_PLAYERS = new String[]{"rammi.Rammi", "Sample", "Stupid"};
    public static final String DEFAULT_HOSTNAME = "127.0.0.1";
    public static final String ONLINE_MAME_HOSTNAME = "asteroids.heise.de";

    private static PlayerStarter createPlayerStarter(String name) throws Throwable {
        Class<?> clazz = Class.forName(name);
        return (PlayerStarter)clazz.newInstance();
    }

    public static Throwable[] startPlayer(String name, Communication com) {
        String[] possibleClassNames = AsteroidPlayerRunner.createPossiblePlayerStarterClassnames(name);
        Throwable[] exceptions = new Throwable[possibleClassNames.length];
        for (int c = 0; c < possibleClassNames.length; ++c) {
            try {
                PlayerStarter starter = AsteroidPlayerRunner.createPlayerStarter(possibleClassNames[c]);
                starter.startPlayer(com);
                return null;
            }
            catch (Throwable throwable) {
                exceptions[c] = throwable;
                continue;
            }
        }
        return exceptions;
    }

    private static String[] createPossiblePlayerStarterClassnames(String name) {
        return new String[]{name, name + OPTIONAL_PLAYER_STARTER_EXTENSION, DEFAULT_PLAYER_STARTER_PACKAGE + name, DEFAULT_PLAYER_STARTER_PACKAGE + name + OPTIONAL_PLAYER_STARTER_EXTENSION};
    }

    public static void main(String[] args) {
        String hostname = DEFAULT_HOSTNAME;
        boolean withDisplay = false;
        boolean bridgeMode = false;
        int bridgePort = 0;
        boolean nextIsBridgePort = false;
        String dumpfile = null;
        boolean nextIsDumpFile = false;
        String player = null;
        boolean nextIsPlayer = false;
        String onlineName = null;
        boolean nextIsOnlineName = false;
        boolean humanClient = false;
        for (String arg : args) {
            if (nextIsBridgePort) {
                nextIsBridgePort = false;
                try {
                    bridgePort = Integer.parseInt(arg);
                }
                catch (NumberFormatException e) {
                    System.err.println(String.format("Bridgemode -b requires numeric port, but has %s!", arg));
                    System.exit(1);
                }
                continue;
            }
            if (nextIsDumpFile) {
                dumpfile = arg;
                nextIsDumpFile = false;
                continue;
            }
            if (nextIsPlayer) {
                player = arg;
                nextIsPlayer = false;
                continue;
            }
            if (nextIsOnlineName) {
                onlineName = arg;
                nextIsOnlineName = false;
                continue;
            }
            if ("-d".equals(arg)) {
                withDisplay = true;
                continue;
            }
            if ("-b".equals(arg)) {
                bridgeMode = true;
                nextIsBridgePort = true;
                continue;
            }
            if ("-s".equals(arg)) {
                nextIsDumpFile = true;
                continue;
            }
            if ("-p".equals(arg)) {
                nextIsPlayer = true;
                continue;
            }
            if ("-n".equals(arg)) {
                nextIsOnlineName = true;
                continue;
            }
            if ("-P".equals(arg)) {
                if (hostname == DEFAULT_HOSTNAME) {
                    hostname = ONLINE_MAME_HOSTNAME;
                }
                humanClient = true;
                continue;
            }
            hostname = arg;
        }
        if (nextIsBridgePort) {
            System.err.println("Bridgemode -b requires port number!");
            System.exit(1);
        }
        if (nextIsDumpFile) {
            System.err.println("Save dump -s requires filename!");
            System.exit(1);
        }
        if (nextIsPlayer) {
            System.err.println("Player option -p requires player starter classname!");
            System.exit(1);
        }
        if (nextIsOnlineName) {
            System.err.println("Name option -n requires onlineName");
            System.exit(1);
        }
        if (humanClient) {
            new HumanClient(hostname);
        } else {
            try {
                Communication com = new Communication(hostname, bridgeMode, onlineName);
                Thread comThread = new Thread((Runnable)com, "Communication");
                comThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    public void uncaughtException(Thread t, Throwable e) {
                        System.err.println("Communication thread passed out.");
                        e.printStackTrace(System.err);
                        System.exit(2);
                    }
                });
                if (dumpfile != null) {
                    try {
                        DatagramDumper.registerDumper(com, dumpfile);
                    }
                    catch (IOException e) {
                        System.err.println("Cannot create dump file:");
                        e.printStackTrace(System.err);
                        System.exit(1);
                    }
                }
                JFrame frame = null;
                if (withDisplay) {
                    frame = new JFrame(bridgeMode ? "Bridge Display" : "Frame Display");
                    FrameDisplay display = new FrameDisplay(640);
                    frame.getContentPane().add(display);
                    frame.pack();
                    frame.setVisible(true);
                    frame.setDefaultCloseOperation(3);
                    com.addFrameListener(display);
                }
                if (bridgeMode) {
                    Bridge bridge = new Bridge(bridgePort, com);
                    Thread bridgeThread = new Thread((Runnable)bridge, "Bridge");
                    bridgeThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        public void uncaughtException(Thread t, Throwable e) {
                            System.err.println("Bridge thread passed out.");
                            e.printStackTrace(System.err);
                            System.exit(2);
                        }
                    });
                    bridgeThread.start();
                    com.addDatagramListener(bridge);
                    com.setFramePreparer(new FramePreparerSequence(new FramePreparer[]{new SimpleVelocityPreparer(), new ScoreFixer()}));
                } else {
                    AutoStarter.install(com);
                    if (player != null) {
                        Throwable[] errors = AsteroidPlayerRunner.startPlayer(player, com);
                        if (errors != null) {
                            System.err.println(String.format("Could start the player '%s', trying different combinations:", player));
                            String[] classnames = AsteroidPlayerRunner.createPossiblePlayerStarterClassnames(player);
                            for (int t = 0; t < errors.length; ++t) {
                                System.err.println(String.format("\t'%s' failed for the following reason: %s", classnames[t], errors[t]));
                            }
                            System.exit(2);
                        }
                        if (frame != null) {
                            frame.setTitle(String.format("%s [%s]", frame.getTitle(), player));
                        }
                    } else {
                        boolean success = false;
                        for (String name : DEFAULT_PLAYERS) {
                            if (AsteroidPlayerRunner.startPlayer(name, com) != null) continue;
                            success = true;
                            if (frame == null) break;
                            frame.setTitle(String.format("%s [%s]", frame.getTitle(), name));
                            break;
                        }
                        if (!success) {
                            System.err.println("Couldn't start any of the default players, please specify player onlineName on the command line (switch -p)!");
                            System.exit(2);
                        }
                    }
                }
                comThread.start();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(2);
            }
        }
    }
}

