/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.Explosion;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.GameData;
import de.caff.asteroid.GameObjectVisitor;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.ShipExplosion;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Text;
import de.caff.asteroid.Ufo;
import de.caff.asteroid.rammi.AsteroidPlayer;
import de.caff.asteroid.rammi.Futurologist;

public abstract class AbstractBasicFuturologist
implements Futurologist,
GameData {
    protected static final Integer IDENT_UFO = -1;
    protected static final Integer IDENT_SPACE_SHIP = -2;
    protected static final int IDENT_BULLET_OFFSET = Integer.MIN_VALUE;
    private IdentMapper identMapper = new IdentMapper();

    protected static int calcHitTime(Bullet bullet, MovingGameObject obj) {
        int frames = AsteroidPlayer.getFramesUntilCollision(bullet, obj, 69);
        if (frames > 0 && frames + bullet.getLifetime() < 69) {
            return frames;
        }
        return Integer.MAX_VALUE;
    }

    protected void handleFrameInfo(FrameInfo info) {
        this.forgetEverything();
        Ufo ufo = info.getUfo();
        SpaceShip ship = info.getSpaceShip();
        for (Bullet bullet : info.getBullets()) {
            int hitFrames;
            int hit = Integer.MAX_VALUE;
            Integer hitted = null;
            for (Asteroid ast : info.getAsteroids()) {
                int hitFrames2 = AbstractBasicFuturologist.calcHitTime(bullet, ast);
                if (hitFrames2 >= hit) continue;
                hit = hitFrames2;
                hitted = ast.getIdentity();
            }
            if (ufo != null && (hitFrames = AbstractBasicFuturologist.calcHitTime(bullet, ufo)) < hit) {
                hit = hitFrames;
                hitted = IDENT_UFO;
            }
            if (ship != null && (hitFrames = AbstractBasicFuturologist.calcHitTime(bullet, ship)) < hit) {
                hit = hitFrames;
                hitted = IDENT_SPACE_SHIP;
            }
            if (hitted == null) continue;
            this.addHit(hitted, info.getIndex() + hit);
            this.addHit(this.identMapper.getIdent(bullet), info.getIndex() + hit);
        }
    }

    public int getFramesTillDestroyed(MovingGameObject obj, FrameInfo frameInfo) {
        return this.getFramesTillDestroyed(this.identMapper.getIdent(obj), frameInfo);
    }

    protected abstract int getFramesTillDestroyed(Integer var1, FrameInfo var2);

    protected abstract void addHit(Integer var1, int var2);

    protected abstract void forgetEverything();

    private static class IdentMapper
    implements GameObjectVisitor {
        private Integer ident;

        private IdentMapper() {
        }

        Integer getIdent(MovingGameObject obj) {
            if (obj != null) {
                obj.visitedBy(this);
                return this.ident;
            }
            return null;
        }

        public void handle(Asteroid asteroid) {
            this.ident = asteroid.getIdentity();
        }

        public void handle(Bullet bullet) {
            this.ident = bullet.getIdentity() + Integer.MIN_VALUE;
        }

        public void handle(Explosion explosion) {
            this.ident = null;
        }

        public void handle(ShipExplosion explosion) {
            this.ident = null;
        }

        public void handle(SpaceShip ship) {
            this.ident = IDENT_SPACE_SHIP;
        }

        public void handle(Text text) {
            this.ident = null;
        }

        public void handle(Ufo ufo) {
            this.ident = IDENT_UFO;
        }
    }
}

