/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import de.caff.util.Tools;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BulletCounter
implements FrameListener {
    private Map<Integer, Integer> shipBullets = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> ufoBullets = new HashMap<Integer, Integer>();
    private Point shipPos;
    private FrameInfo.Direction shipDirection;
    private Point ufoPos;
    private int vanishingShipBullets;

    public void frameReceived(FrameInfo frame) {
        this.vanishingShipBullets = 0;
        Integer frameNr = frame.getIndex();
        block0: for (Bullet bullet : frame.getBullets()) {
            Integer id = bullet.getIdentity();
            if (this.shipBullets.containsKey(id)) {
                this.shipBullets.put(id, frameNr);
                if (bullet.getLifetime() == 71) {
                    ++this.vanishingShipBullets;
                    continue;
                }
                for (Asteroid ast : frame.getAsteroids()) {
                    if (!bullet.isHitting(ast, 0)) continue;
                    ++this.vanishingShipBullets;
                    continue block0;
                }
                continue;
            }
            if (this.ufoBullets.containsKey(id)) {
                this.ufoBullets.put(id, frameNr);
                continue;
            }
            if (this.shipPos != null && Tools.getLength(bullet.getDelta(this.shipPos)) < Tools.getLength(this.shipDirection.getDisplacement()) + 3.0) {
                this.shipBullets.put(id, frameNr);
                continue;
            }
            if (this.ufoPos == null) continue;
            this.ufoBullets.put(id, frameNr);
        }
        for (Integer id : new ArrayList<Integer>(this.shipBullets.keySet())) {
            if (this.shipBullets.get(id) == frameNr) continue;
            this.shipBullets.remove(id);
        }
        for (Integer id : new ArrayList<Integer>(this.ufoBullets.keySet())) {
            if (this.ufoBullets.get(id) == frameNr) continue;
            this.ufoBullets.remove(id);
        }
        SpaceShip ship = frame.getSpaceShip();
        this.shipPos = ship != null ? ship.getLocation() : null;
        Ufo ufo = frame.getUfo();
        this.ufoPos = ufo != null ? ufo.getLocation() : null;
        this.shipDirection = frame.getNextShootingDirection();
    }

    public int getShipBulletCount() {
        return this.shipBullets.size();
    }

    public int getNextShipBulletCount() {
        return this.getShipBulletCount() - this.vanishingShipBullets;
    }

    public boolean isShipBullet(Bullet bullet) {
        return this.shipBullets.get(bullet.getIdentity()) != null;
    }
}

