/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import de.caff.asteroid.rammi.AbstractBasicAsteroidPlayer;
import de.caff.asteroid.rammi.AsteroidPlayer;
import de.caff.asteroid.rammi.Scorer;
import de.caff.util.Tools;

class DefaultScorer
implements Scorer {
    static final int DANGER_FRAMES = 138;
    static final int DANGER_SCORE = 174;
    static final double NEARNESS_BASE = 762.0;
    static final double ROTATION_BASE = 2.0;
    private static final int REACH_SQUARED = (int)Tools.square(552.0);
    private double dangerFrames;
    private double dangerScore;
    private double nearnessBase;
    private double rotationBase;

    public DefaultScorer(double dangerFrames, double dangerScore, double nearnessBase, double rotationBase) {
        this.dangerFrames = dangerFrames;
        this.dangerScore = dangerScore * dangerFrames * dangerFrames;
        this.nearnessBase = nearnessBase * nearnessBase;
        this.rotationBase = rotationBase;
    }

    public DefaultScorer() {
        this(138.0, 174.0, 762.0, 2.0);
    }

    public double getUfoScore(SpaceShip ship, AbstractBasicAsteroidPlayer.RotateAndWait raw, Ufo ufo, int shots, int numTargets) {
        double score = 0.0;
        double deltaSquared = DefaultScorer.getDeltaSquared(ship, ufo);
        if (deltaSquared < (double)REACH_SQUARED) {
            score += (double)ufo.getScore();
            score += this.getDangerScore(ship, ufo);
            score += this.getNearnessScore(deltaSquared);
            score += this.getRotationScore(ship, raw, ufo, numTargets);
        }
        return score;
    }

    public double getAsteroidScore(SpaceShip ship, AbstractBasicAsteroidPlayer.RotateAndWait raw, Asteroid ast, int shots, int numTargets) {
        double score = 0.0;
        double deltaSquared = DefaultScorer.getDeltaSquared(ship, ast);
        if (deltaSquared < (double)REACH_SQUARED) {
            score += this.getDangerScore(ship, ast);
            score += this.getNearnessScore(deltaSquared);
            score += this.getRotationScore(ship, raw, ast, numTargets);
        }
        return score;
    }

    private static double getDeltaSquared(SpaceShip ship, MovingGameObject object) {
        double deltaX = GameObject.normalizeDeltaX(object.getCorrectedX() - ship.getCorrectedX());
        double deltaY = GameObject.normalizeDeltaY(object.getCorrectedY() - ship.getCorrectedY());
        return deltaX * deltaX + deltaY * deltaY;
    }

    private double getDangerScore(SpaceShip ship, MovingGameObject object) {
        int frames = AsteroidPlayer.getFramesUntilCollision(ship, object, (int)this.dangerFrames);
        if (frames > 0 && (double)frames < this.dangerFrames) {
            return this.dangerScore / (double)(frames * frames);
        }
        return 0.0;
    }

    private double getNearnessScore(double deltaSquared) {
        return this.nearnessBase / deltaSquared;
    }

    private double getRotationScore(SpaceShip ship, AbstractBasicAsteroidPlayer.RotateAndWait raw, MovingGameObject object, int numTargets) {
        if (this.rotationBase != 0.0 && raw != null) {
            return this.rotationBase / (double)(Math.abs(raw.getHitFrames()) + 1);
        }
        return 0.0;
    }
}

