/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.GameData;
import de.caff.asteroid.PingKeyProvider;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.server.DatagramListener;
import de.caff.asteroid.server.DatagramSender;
import de.caff.util.Tools;
import java.awt.Point;
import java.net.DatagramPacket;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShootingDirectionFixer
implements FramePreparer,
DatagramListener,
PingKeyProvider,
GameData {
    private KeyInfo[] pendingKeys;
    private PingKeyProvider pinky;

    public ShootingDirectionFixer() {
        this.pendingKeys = new KeyInfo[256];
        this.pinky = this;
    }

    public ShootingDirectionFixer(PingKeyProvider pinky) {
        this.pinky = pinky;
    }

    @Override
    public void datagramReceived(DatagramPacket packet, DatagramSender sender) {
    }

    @Override
    public void datagramSent(DatagramPacket packet) {
        KeyInfo info;
        this.pendingKeys[info.getPing()] = info = new KeyInfo(packet);
    }

    @Override
    public void prepareFrames(LinkedList<FrameInfo> frameInfos) {
        if (frameInfos.size() > 2) {
            FrameInfo currentInfo = frameInfos.getLast();
            FrameInfo lastInfo = frameInfos.get(frameInfos.size() - 2);
            SpaceShip spaceShip = currentInfo.getSpaceShip();
            if (spaceShip == null && lastInfo.getSpaceShip() != null) {
                lastInfo.setNextShootingDirectionLowLevel(lastInfo.getShootingDirectionLowLevel());
            }
            currentInfo.inheritShootingDirectionsFrom(lastInfo);
            if (currentInfo.getPing() != 0 && currentInfo.getPing() != lastInfo.getPing() && spaceShip != null) {
                int keys;
                if (!currentInfo.getShootingDirection().getShipDirection().equals(spaceShip.getDirection())) {
                    ShootingDirectionFixer.fixShootingDirection(currentInfo);
                }
                if (((keys = this.pinky.getKeysForPing(currentInfo.getIndex(), currentInfo.getPing())) & 0x10) != 0) {
                    currentInfo.turnNextShootingDirectionLeft();
                }
                if ((keys & 8) != 0) {
                    currentInfo.turnNextShootingDirectionRight();
                }
            }
        }
    }

    private static void fixShootingDirection(FrameInfo info) {
        Point shipDir = info.getSpaceShip().getDirection();
        int shootDir = Tools.byteToUnsigned(info.getShootingDirectionLowLevel());
        for (int i = 1; i <= FrameInfo.SHOOTING_DIRECTIONS.length / 2; ++i) {
            int test = (shootDir + i) % FrameInfo.SHOOTING_DIRECTIONS.length;
            if (FrameInfo.SHOOTING_DIRECTIONS[test].getShipDirection().equals(shipDir)) {
                info.setBothShootingDirectionsLowLevel((byte)test);
                break;
            }
            test = (shootDir + FrameInfo.SHOOTING_DIRECTIONS.length - i) % FrameInfo.SHOOTING_DIRECTIONS.length;
            if (!FrameInfo.SHOOTING_DIRECTIONS[test].getShipDirection().equals(shipDir)) continue;
            info.setBothShootingDirectionsLowLevel((byte)test);
            break;
        }
    }

    @Override
    public int getKeysForPing(int frameNr, int ping) {
        if (this.pendingKeys[ping] != null) {
            KeyInfo keyInfo = this.pendingKeys[ping];
            return keyInfo.getKey();
        }
        return 0;
    }

    @Override
    public long getTimestampForPing(int frameNr, int ping) {
        return 0L;
    }

    @Override
    public boolean isStillKnown(int frameNr, int ping) {
        return true;
    }

    private static class KeyInfo {
        private final int key;
        private final int ping;

        public KeyInfo(DatagramPacket packet) {
            this.key = Tools.byteToUnsigned(packet.getData()[GameData.KEY_MASK_INDEX]);
            this.ping = Tools.byteToUnsigned(packet.getData()[GameData.KEY_PING_INDEX]);
        }

        public int getKey() {
            return this.key;
        }

        public boolean hasLeftPressed() {
            return (this.key & 0x10) != 0;
        }

        public boolean hasRightPressed() {
            return (this.key & 8) != 0;
        }

        public int getPing() {
            return this.ping;
        }
    }
}

