/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.GameData;
import de.caff.asteroid.PlayerStarter;

public class TestPlayerStarter
implements PlayerStarter,
GameData {
    public void startPlayer(Communication com) {
        TestPlayer player = new TestPlayer(com);
        com.addFrameListener(player);
    }

    private static class TestPlayer
    implements FrameListener {
        private static final int[] BUTTON_SEQUENCE = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 2};
        private Communication com;
        private int prefix = 8;
        private int rotate;
        private int rotateKey;
        private boolean fire = false;

        private TestPlayer(Communication com) {
            this.com = com;
            if (System.getProperty("TestRotate") != null) {
                this.rotate = Integer.parseInt(System.getProperty("TestRotate"));
                if (this.rotate < 0) {
                    this.rotate = -this.rotate;
                    this.rotateKey = 8;
                } else if (this.rotate == 0) {
                    this.fire = true;
                } else {
                    this.rotateKey = 16;
                }
            }
        }

        public void frameReceived(FrameInfo frame) {
            if (frame.getSpaceShip() != null) {
                if (this.prefix > 0) {
                    --this.prefix;
                } else if (this.rotate-- > 0) {
                    this.com.pushButton(this.rotateKey);
                    if (this.rotate == 0) {
                        this.prefix = 2;
                        this.fire = true;
                    }
                } else if (this.fire) {
                    this.com.pushButton(2);
                    this.fire = false;
                    this.prefix = 16;
                } else {
                    System.exit(0);
                }
            }
        }
    }
}

