// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.analysis;

/**
 *  Interface for access to the applet display.
 *  Used to hide the fact whether the applet is displayed in-page or in a frame.
 */
public interface AnalysisAppletDisplay
{
  /**
   *  Load a new dump file.
   *  Invoke this method from JavaScript as a workaround to bug #6669818.
   *  @param dumpFile dump file
   *  @param autoStart start automatically after file is loaded?
   */
  void showDumpFile(String dumpFile, boolean autoStart);

  /**
   *  Start animation if it is not running.
   */
  void startAnimation();

  /**
   *  Stop animation if it is running.
   */
  void stopAnimation();
}
