// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.rammi;

/**
 *  Not a player at all, just available to preallocate memory used for
 *  {@link BulletLifetimeInformation} without accessing the communication.
 *  Use the {@link MemoryHog#oinkOink()} method for this purpose.
 */
public class MemoryHog
        extends AbstractBasicAsteroidPlayer
{
  /** Hogging once is enough. */
  private static boolean hogged = false;

  /**
   * Constructor only for memory hogging.
   */
  private MemoryHog()
  {
  }

  /**
   * Call this to cleanup any resources taken by this object.
   */
  public void destroy()
  {
  }

  /**
   *  Hog some memory in another thread.
   */
  public static void oinkOink()
  {
    if (!hogged) {
      hogged = true;
      new Thread(new Runnable() {
        public void run()
        {
          new MemoryHog();
        }
      }).start();
    }
  }
}
