// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.rammi;

import de.caff.asteroid.*;

/**
 *  Start Rammi's player.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public class RammiPlayerStarter
        implements PlayerStarter
{
  /**
   * Start the player.
   *
   * @param com communication access
   */
  public void startPlayer(Communication com)
  {
    System.out.println("Rammis Player Version "+AsteroidPlayer.VERSION);
    AsteroidPlayer player = new AsteroidPlayer(com);
    //AsteroidPlayerOld1 player = new AsteroidPlayerOld1(com);
    com.addFrameListener(player);
    com.addFrameListener(new TimedScorePrinter(60*60));
    com.addFrameListener(new HallOfFameFiller(com, "ram"));
    com.addFrameListener(new LevelPauseGarbageCollector(com));
    com.addServerStateListener(new AutoRestarter(com));
  }
}
